/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Dispatch;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.common.configuration.ConfigHelper;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.security.ClientConfigProvider;
import org.jboss.wsf.spi.security.JASPIAuthenticationProvider;
import org.jboss.wsf.stack.cxf.client.configuration.ClientConfigConduitSelector;
import org.jboss.wsf.stack.cxf.client.configuration.FeatureUtils;
import org.jboss.wsf.stack.cxf.client.configuration.InterceptorUtils;
import org.jboss.wsf.stack.cxf.client.configuration.PropertyReferenceUtils;
import org.jboss.wsf.stack.cxf.i18n.Loggers;

public class CXFClientConfigurer
extends ConfigHelper {
    private static final String JBOSSWS_CXF_CLIENT_CONF_PROPS = "jbossws.cxf.client.conf.props";

    public void setConfigProperties(Object client, String configFile, String configName) {
        Class<?> clazz = !(client instanceof Dispatch) ? client.getClass() : null;
        ClientConfig config = this.readConfig(configFile, configName, clazz, (BindingProvider)client);
        this.setConfigProperties(client, config);
    }

    protected void setConfigProperties(Object client, ClientConfig config) {
        ClientConfigProvider clientConfigProvider;
        JASPIAuthenticationProvider japsiProvider;
        Client cxfClient = client instanceof DispatchImpl ? ((DispatchImpl)client).getClient() : ClientProxy.getClient((Object)client);
        this.cleanupPreviousProps(cxfClient);
        Map props = config.getProperties();
        if (props != null && !props.isEmpty()) {
            this.savePropList(cxfClient, props);
        }
        this.setConfigProperties(cxfClient, props);
        Map attachments = config.getAttachments();
        if (attachments != null && !attachments.isEmpty()) {
            cxfClient.getEndpoint().putAll(attachments);
        }
        if ((japsiProvider = (JASPIAuthenticationProvider)ServiceLoader.loadService((String)JASPIAuthenticationProvider.class.getName(), null, (ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader())) != null) {
            japsiProvider.enableClientAuthentication((Object)cxfClient, props);
        } else {
            Loggers.SECURITY_LOGGER.cannotFindJaspiClasses();
        }
        if (props != null && config.getAttachments().get("clientProviderConfigured") != null && config.getAttachments().get("clientProviderConfigured").toString().equalsIgnoreCase("true") && (clientConfigProvider = (ClientConfigProvider)ServiceLoader.loadService((String)ClientConfigProvider.class.getName(), null, (ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader())) != null) {
            String endpointAddress = ((BindingProvider)client).getRequestContext().get("javax.xml.ws.service.endpoint.address").toString();
            this.enableClientConfigProvider(clientConfigProvider, cxfClient, endpointAddress);
        }
    }

    public void setConfigProperties(Client client, Map<String, String> properties) {
        client.getEndpoint().putAll(properties);
        InterceptorUtils.addInterceptors((InterceptorProvider)client, properties);
        FeatureUtils.addFeatures((InterceptorProvider)client, client.getBus(), properties);
        PropertyReferenceUtils.createPropertyReference(properties, client.getBus().getProperties());
    }

    private void enableClientConfigProvider(ClientConfigProvider clientConfigProvider, Client cxfClient, String endpointAddress) {
        Map requestContext = cxfClient.getRequestContext();
        if (requestContext.get("com.sun.xml.ws.transport.https.client.SSLSocketFactory") == null) {
            this.setClientConfigProviderConduitSelector(cxfClient);
        } else {
            this.setHttpBasicProperties(cxfClient);
        }
        if (cxfClient.getEndpoint().get((Object)"clientUsername") != null && cxfClient.getEndpoint().get((Object)"clientWSSecurityType") != null && cxfClient.getEndpoint().get((Object)"clientWSSecurityType").toString().equalsIgnoreCase("usernametoken")) {
            this.setUsernameTokenProperties(cxfClient);
        }
    }

    private void setHttpBasicProperties(Client cxfClient) {
        Map requestContext;
        Endpoint cxfClientEndpoint = cxfClient.getEndpoint();
        if (cxfClientEndpoint.get((Object)"clientUsername") != null && (cxfClientEndpoint.get((Object)"clientHttpMechanism") == null && cxfClientEndpoint.get((Object)"clientWSSecurityType") == null || cxfClientEndpoint.get((Object)"clientHttpMechanism").toString().equalsIgnoreCase("basic")) && (requestContext = cxfClient.getRequestContext()).get("javax.xml.ws.security.auth.username") == null && requestContext.get("javax.xml.ws.security.auth.password") == null) {
            requestContext.put("javax.xml.ws.security.auth.username", cxfClientEndpoint.get((Object)"clientUsername"));
            requestContext.put("javax.xml.ws.security.auth.password", cxfClientEndpoint.get((Object)"clientPassword"));
        }
    }

    private void setUsernameTokenProperties(Client cxfClient) {
        Map requestContext = cxfClient.getRequestContext();
        if (requestContext.get("security.username") == null && requestContext.get("security.password") == null && requestContext.get("security.callback-handler") == null) {
            requestContext.put("security.username", cxfClient.getEndpoint().get((Object)"clientUsername"));
            requestContext.put("security.callback-handler", callbacks -> {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[0];
                pc.setPassword(cxfClient.getEndpoint().get((Object)"clientPassword").toString());
            });
        }
    }

    private void setClientConfigProviderConduitSelector(Client cxfClient) {
        ClientConfigConduitSelector clientConfigProviderHttpConduitSelector = new ClientConfigConduitSelector();
        clientConfigProviderHttpConduitSelector.setEndpoint(cxfClient.getEndpoint());
        cxfClient.setConduitSelector((ConduitSelector)clientConfigProviderHttpConduitSelector);
    }

    private void savePropList(Client client, Map<String, String> props) {
        Set<String> keys = props.keySet();
        client.getEndpoint().put((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS, (Object)keys.toArray(new String[keys.size()]));
    }

    private void cleanupPreviousProps(Client client) {
        Endpoint ep = client.getEndpoint();
        String[] previousProps = (String[])ep.get((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS);
        if (previousProps != null) {
            for (String p : previousProps) {
                if ("cxf.interceptors.in".equals(p)) {
                    InterceptorUtils.removeInterceptors(client.getInInterceptors(), (String)ep.get((Object)p));
                } else if ("cxf.interceptors.out".equals(p)) {
                    InterceptorUtils.removeInterceptors(client.getOutInterceptors(), (String)ep.get((Object)p));
                } else if ("cxf.interceptors.infault".equals(p)) {
                    InterceptorUtils.removeInterceptors(client.getInFaultInterceptors(), (String)ep.get((Object)p));
                } else if ("cxf.interceptors.outfault".equals(p)) {
                    InterceptorUtils.removeInterceptors(client.getOutFaultInterceptors(), (String)ep.get((Object)p));
                } else if ("cxf.features".equals(p)) {
                    Loggers.ROOT_LOGGER.couldNoRemoveFeaturesOnClient((String)ep.get((Object)p));
                }
                ep.remove((Object)p);
            }
            ep.remove((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS);
        }
    }
}

