/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.batchindexing.impl;

import jakarta.transaction.SystemException;
import java.lang.invoke.MethodHandles;
import org.hibernate.StatelessSession;
import org.hibernate.search.batchindexing.impl.BatchTransactionalContext;
import org.hibernate.search.batchindexing.impl.ErrorHandledRunnable;
import org.hibernate.search.batchindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class OptionallyWrapInJTATransaction
extends ErrorHandledRunnable {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private final StatelessSessionAwareRunnable statelessSessionAwareRunnable;
    private final BatchTransactionalContext batchContext;
    private final Integer transactionTimeout;
    private final boolean wrapInTransaction;
    private final String tenantId;

    public OptionallyWrapInJTATransaction(BatchTransactionalContext batchContext, StatelessSessionAwareRunnable statelessSessionAwareRunnable, Integer transactionTimeout, String tenantId) {
        super(batchContext.extendedIntegrator);
        this.batchContext = batchContext;
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.statelessSessionAwareRunnable = statelessSessionAwareRunnable;
        this.wrapInTransaction = batchContext.wrapInTransaction();
    }

    @Override
    public void runWithErrorHandler() throws Exception {
        if (this.wrapInTransaction) {
            StatelessSession statelessSession = this.batchContext.factory.withStatelessOptions().tenantIdentifier(this.tenantId).openStatelessSession();
            if (this.transactionTimeout != null) {
                this.batchContext.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
            }
            this.batchContext.transactionManager.begin();
            this.statelessSessionAwareRunnable.run(statelessSession);
            this.batchContext.transactionManager.commit();
            statelessSession.close();
        } else {
            this.statelessSessionAwareRunnable.run(null);
        }
    }

    @Override
    protected void cleanUpOnError() {
        if (this.wrapInTransaction) {
            try {
                this.batchContext.transactionManager.rollback();
            }
            catch (SystemException e) {
                log.errorRollingBackTransaction(e.getMessage(), (Exception)((Object)e));
            }
        }
    }
}

