/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.jaxrs;

import io.smallrye.metrics.MetricRegistries;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.time.Duration;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;

public class JaxRsMetricsServletFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        long start = System.nanoTime();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        catch (Throwable throwable) {
            MetricID metricID = (MetricID)servletRequest.getAttribute("smallrye.metrics.jaxrs.metricID");
            if (metricID != null) {
                MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.BASE);
                if (!registry.getMetricIDs().contains(metricID)) {
                    Metadata metadata = Metadata.builder().withName(metricID.getName()).withDescription("The number of invocations and total response time of this RESTful resource method since the start of the server.").withUnit("nanoseconds").build();
                    registry.simpleTimer(metadata, metricID.getTagsAsArray());
                }
                if (!servletRequest.isAsyncStarted()) {
                    this.updateMetric(start, metricID);
                } else {
                    servletRequest.getAsyncContext().addListener(new AsyncListener(start, metricID){
                        final /* synthetic */ long val$start;
                        final /* synthetic */ MetricID val$metricID;
                        {
                            this.val$start = l;
                            this.val$metricID = metricID;
                        }

                        public void onComplete(AsyncEvent event) {
                            JaxRsMetricsServletFilter.this.updateMetric(this.val$start, this.val$metricID);
                        }

                        public void onTimeout(AsyncEvent event) {
                            JaxRsMetricsServletFilter.this.updateMetric(this.val$start, this.val$metricID);
                        }

                        public void onError(AsyncEvent event) {
                            JaxRsMetricsServletFilter.this.updateMetric(this.val$start, this.val$metricID);
                        }

                        public void onStartAsync(AsyncEvent event) {
                        }
                    });
                }
            }
            throw throwable;
        }
        MetricID metricID = (MetricID)servletRequest.getAttribute("smallrye.metrics.jaxrs.metricID");
        if (metricID != null) {
            MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.BASE);
            if (!registry.getMetricIDs().contains(metricID)) {
                Metadata metadata = Metadata.builder().withName(metricID.getName()).withDescription("The number of invocations and total response time of this RESTful resource method since the start of the server.").withUnit("nanoseconds").build();
                registry.simpleTimer(metadata, metricID.getTagsAsArray());
            }
            if (!servletRequest.isAsyncStarted()) {
                this.updateMetric(start, metricID);
            } else {
                servletRequest.getAsyncContext().addListener(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    public void updateMetric(long startTimestamp, MetricID metricID) {
        long duration = System.nanoTime() - startTimestamp;
        MetricRegistry registry = MetricRegistries.get(MetricRegistry.Type.BASE);
        ((SimpleTimer)registry.getSimpleTimers().get(metricID)).update(Duration.ofNanos(duration));
    }

    public void destroy() {
    }
}

