/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.ThreadsWriteAttributeOperationHandler;
import org.jboss.as.threads.TimeSpec;
import org.jboss.as.threads.UnboundedQueueThreadPoolAdd;
import org.jboss.as.threads.UnboundedQueueThreadPoolService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class UnboundedQueueThreadPoolWriteAttributeHandler
extends ThreadsWriteAttributeOperationHandler {
    private final ServiceName serviceNameBase;
    private final RuntimeCapability capability;

    @Deprecated
    public UnboundedQueueThreadPoolWriteAttributeHandler(ServiceName serviceNameBase) {
        this(null, serviceNameBase);
    }

    public UnboundedQueueThreadPoolWriteAttributeHandler(RuntimeCapability capability, ServiceName serviceNameBase) {
        super(UnboundedQueueThreadPoolAdd.ATTRIBUTES, UnboundedQueueThreadPoolAdd.RW_ATTRIBUTES);
        this.serviceNameBase = serviceNameBase;
        this.capability = capability;
    }

    @Override
    protected void applyOperation(OperationContext context, ModelNode model, String attributeName, ServiceController<?> service, boolean forRollback) throws OperationFailedException {
        UnboundedQueueThreadPoolService pool = (UnboundedQueueThreadPoolService)service.getService();
        if (PoolAttributeDefinitions.KEEPALIVE_TIME.getName().equals(attributeName)) {
            TimeUnit defaultUnit = pool.getKeepAliveUnit();
            TimeSpec spec = UnboundedQueueThreadPoolWriteAttributeHandler.getTimeSpec(context, model, defaultUnit);
            pool.setKeepAlive(spec);
        } else if (PoolAttributeDefinitions.MAX_THREADS.getName().equals(attributeName)) {
            pool.setMaxThreads(PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt());
        } else if (!forRollback) {
            throw ThreadsLogger.ROOT_LOGGER.unsupportedUnboundedQueueThreadPoolAttribute(attributeName);
        }
    }

    @Override
    protected ServiceController<?> getService(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        ServiceName serviceName = null;
        ServiceController controller = null;
        if (this.capability != null) {
            serviceName = this.capability.getCapabilityServiceName(context.getCurrentAddress());
            controller = context.getServiceRegistry(true).getService(serviceName);
            if (controller != null) {
                return controller;
            }
        }
        if (this.serviceNameBase != null) {
            serviceName = this.serviceNameBase.append(new String[]{name});
            controller = context.getServiceRegistry(true).getService(serviceName);
        }
        if (controller == null) {
            throw ThreadsLogger.ROOT_LOGGER.unboundedQueueThreadPoolServiceNotFound(serviceName);
        }
        return controller;
    }
}

