/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.wildfly.clustering.marshalling.protostream.MarshallerProvider;
import org.wildfly.clustering.marshalling.protostream.Predictable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;

public enum PrimitiveMarshaller implements MarshallerProvider
{
    VOID((Class)Void.class){

        @Override
        public Boolean readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return null;
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(0);
        }
    }
    ,
    BOOLEAN((Class)Boolean.class){

        @Override
        public Boolean readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return reader.readBool();
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeBoolNoTag(((Boolean)value).booleanValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(1);
        }
    }
    ,
    BYTE((Class)Byte.class){

        @Override
        public Byte readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return ((RawProtoStreamReaderImpl)reader).getDelegate().readRawByte();
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeRawByte(((Byte)value).byteValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(1);
        }
    }
    ,
    SHORT((Class)Short.class){

        @Override
        public Short readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return (short)reader.readSInt32();
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeSInt32NoTag((int)((Short)value).shortValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(Predictable.signedIntSize(((Short)value).shortValue()));
        }
    }
    ,
    INTEGER((Class)Integer.class){

        @Override
        public Integer readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return reader.readSInt32();
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeSInt32NoTag(((Integer)value).intValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(Predictable.signedIntSize((Integer)value));
        }
    }
    ,
    LONG((Class)Long.class){

        @Override
        public Long readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return reader.readSInt64();
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeSInt64NoTag(((Long)value).longValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(Predictable.signedLongSize((Long)value));
        }
    }
    ,
    FLOAT((Class)Float.class){

        @Override
        public Float readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return Float.valueOf(reader.readFloat());
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeFloatNoTag(((Float)value).floatValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(4);
        }
    }
    ,
    DOUBLE((Class)Double.class){

        @Override
        public Double readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return reader.readDouble();
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            ((RawProtoStreamWriterImpl)writer).getDelegate().writeDoubleNoTag(((Double)value).doubleValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            return OptionalInt.of(8);
        }
    }
    ,
    CHARACTER((Class)Character.class){

        @Override
        public Character readFrom(ImmutableSerializationContext context, RawProtoStreamReader reader) throws IOException {
            return Character.valueOf((char)reader.readUInt32());
        }

        @Override
        public void writeTo(ImmutableSerializationContext context, RawProtoStreamWriter writer, Object value) throws IOException {
            Character character = (Character)value;
            writer.writeUInt32NoTag((int)character.charValue());
        }

        @Override
        public OptionalInt size(ImmutableSerializationContext context, Object value) {
            Character character = (Character)value;
            return OptionalInt.of(Predictable.unsignedIntSize(character.charValue()));
        }
    };

    private final Class<?> primitiveClass;

    private PrimitiveMarshaller(Class<?> primitiveClass) {
        this.primitiveClass = primitiveClass;
    }

    @Override
    public Class<? extends Object> getJavaClass() {
        return this.primitiveClass;
    }

    @Override
    public ProtoStreamMarshaller<?> getMarshaller() {
        return this;
    }
}

