/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.LockModeType;
import org.hibernate.LockMode;
import org.hibernate.internal.util.LockModeConverter;

public final class LockModeTypeHelper {
    private LockModeTypeHelper() {
    }

    public static LockModeType getLockModeType(LockMode lockMode) {
        return LockModeConverter.convertToLockModeType(lockMode);
    }

    public static LockMode getLockMode(LockModeType lockModeType) {
        return LockModeConverter.convertToLockMode(lockModeType);
    }

    public static LockMode interpretLockMode(Object value) {
        if (value == null) {
            return LockMode.NONE;
        }
        if (LockMode.class.isInstance(value)) {
            return (LockMode)((Object)value);
        }
        if (LockModeType.class.isInstance(value)) {
            return LockModeTypeHelper.getLockMode((LockModeType)value);
        }
        if (String.class.isInstance(value)) {
            LockMode lockMode = LockMode.valueOf((String)value);
            if (lockMode == null) {
                try {
                    lockMode = LockModeTypeHelper.getLockMode(LockModeType.valueOf((String)((String)value)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (lockMode != null) {
                return lockMode;
            }
        }
        throw new IllegalArgumentException("Unknown lock mode source : " + value);
    }
}

