/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.domain.controller.operations.deployment.SyncModelParameters;
import org.jboss.as.host.controller.ManagedServerBootCmdFactory;
import org.jboss.as.host.controller.ManagedServerBootConfiguration;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResource;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.server.deployment.ModelContentReference;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

class SyncServerStateOperationHandler
implements OperationStepHandler {
    private final SyncModelParameters parameters;
    private final List<ModelNode> operations;

    public SyncServerStateOperationHandler(SyncModelParameters parameters, List<ModelNode> operations) {
        this.parameters = parameters;
        this.operations = operations;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        assert (!context.isBooting()) : "Should not be used when the context is booting";
        assert (this.parameters.isFullModelTransfer()) : "Should only be used during a full model transfer";
        Resource startResource = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, true);
        final ModelNode startRoot = Resource.Tools.readModel((Resource)startResource);
        final String localHostName = (String)startResource.getChildrenNames("host").iterator().next();
        final ModelNode startHostModel = ((Property)startRoot.require("host").asPropertyList().iterator().next()).getValue();
        if (!startHostModel.hasDefined("server-config")) {
            return;
        }
        final ServerOperationResolver resolver = new ServerOperationResolver(localHostName, this.parameters.getServerProxies());
        context.addStep(operation, new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                Resource domainRootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
                ModelNode endRoot = Resource.Tools.readModel((Resource)domainRootResource);
                ModelNode endHostModel = ((Property)endRoot.require("host").asPropertyList().iterator().next()).getValue();
                final ContentDownloader contentDownloader = new ContentDownloader(startRoot, endRoot, endHostModel);
                Map servers = SyncServerStateOperationHandler.this.determineServerStateChanges(context, domainRootResource, resolver, contentDownloader);
                for (String string : endHostModel.get("server-config").keys()) {
                    SyncServerResultAction restart = (SyncServerResultAction)((Object)servers.get(string));
                    if (restart != null && restart != SyncServerResultAction.RELOAD_REQUIRED) continue;
                    ManagedServerBootConfiguration startConfig = new ManagedServerBootCmdFactory(string, startRoot, startHostModel, SyncServerStateOperationHandler.this.parameters.getHostControllerEnvironment(), SyncServerStateOperationHandler.this.parameters.getDomainController().getExpressionResolver(), false).createConfiguration();
                    ManagedServerBootConfiguration endConfig = new ManagedServerBootCmdFactory(string, endRoot, endHostModel, SyncServerStateOperationHandler.this.parameters.getHostControllerEnvironment(), SyncServerStateOperationHandler.this.parameters.getDomainController().getExpressionResolver(), false).createConfiguration();
                    if (startConfig != null && startConfig.compareServerLaunchCommand(endConfig)) continue;
                    servers.put(string, SyncServerResultAction.RESTART_REQUIRED);
                }
                for (Map.Entry entry : servers.entrySet()) {
                    PathAddress serverAddress = PathAddress.pathAddress((String)"host", (String)localHostName).append("server", (String)entry.getKey());
                    String opName = entry.getValue() == SyncServerResultAction.RESTART_REQUIRED ? "server-set-restart-required" : "server-set-reload-required";
                    OperationStepHandler handler = context.getResourceRegistration().getOperationHandler(serverAddress, opName);
                    ModelNode op = Util.createEmptyOperation((String)opName, (PathAddress)serverAddress);
                    context.addStep(op, handler, OperationContext.Stage.MODEL);
                }
                context.completeStep(new OperationContext.ResultHandler(){

                    public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                        if (resultAction == OperationContext.ResultAction.KEEP) {
                            for (ContentReference ref : contentDownloader.removedContent) {
                                SyncServerStateOperationHandler.this.parameters.getContentRepository().removeContent(ref);
                            }
                        }
                    }
                });
            }
        }, OperationContext.Stage.MODEL);
    }

    private Map<String, SyncServerResultAction> determineServerStateChanges(OperationContext context, Resource domainRootResource, ServerOperationResolver resolver, ContentDownloader contentDownloader) {
        HashMap<String, SyncServerResultAction> serverStateChanges = new HashMap<String, SyncServerResultAction>();
        for (ModelNode operation : this.operations) {
            PathAddress addr = PathAddress.pathAddress((ModelNode)operation.get("address"));
            contentDownloader.checkContent(operation, addr);
            Map<Set<ServerIdentity>, ModelNode> serverMap = resolver.getServerOperations(context, operation, addr);
            for (Map.Entry<Set<ServerIdentity>, ModelNode> entry : serverMap.entrySet()) {
                ModelNode op = entry.getValue();
                String opName = op.get("operation").asString();
                assert (opName != null);
                boolean restart = false;
                if (opName.equals("server-set-restart-required") || !operation.get("operation").asString().equals(opName)) {
                    restart = true;
                }
                if (!restart && !opName.equals("server-set-reload-required") && addr.size() > 1 && addr.getElement(0).getKey().equals("profile")) {
                    restart = this.checkOperationForRestartRequired(context, operation);
                }
                for (ServerIdentity id : entry.getKey()) {
                    String serverName = id.getServerName();
                    SyncServerResultAction existing = (SyncServerResultAction)((Object)serverStateChanges.get(serverName));
                    if (existing != null && (existing != SyncServerResultAction.RELOAD_REQUIRED || !restart)) continue;
                    serverStateChanges.put(serverName, restart ? SyncServerResultAction.RESTART_REQUIRED : SyncServerResultAction.RELOAD_REQUIRED);
                }
            }
        }
        Set<String> affectedServers = contentDownloader.pullDownContent(domainRootResource);
        for (String server : affectedServers) {
            if (serverStateChanges.containsKey(server)) continue;
            serverStateChanges.put(server, SyncServerResultAction.RELOAD_REQUIRED);
        }
        return serverStateChanges;
    }

    private boolean checkOperationForRestartRequired(OperationContext context, ModelNode operation) {
        boolean restart = false;
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String opName = operation.get("operation").asString();
        if ("write-attribute".equals(opName) || "undefine-attribute".equals(opName)) {
            String attributeName = operation.get("name").asString();
            if (registration.getAttributeAccess(address, attributeName).getFlags().contains(AttributeAccess.Flag.RESTART_JVM)) {
                restart = true;
            }
        } else {
            Set flags = registration.getOperationFlags(address, opName);
            if (flags.contains(OperationEntry.Flag.RESTART_JVM)) {
                restart = true;
            }
        }
        return restart;
    }

    private class ContentDownloader {
        private final ModelNode startRoot;
        private final ModelNode endRoot;
        private final Map<String, Set<String>> serversByGroup;
        private final Set<String> affectedGroups = new HashSet<String>();
        private final Map<String, Set<ContentReference>> deploymentHashes = new HashMap<String, Set<ContentReference>>();
        private final Set<String> relevantDeployments = new HashSet<String>();
        private final Set<ContentReference> requiredContent = new HashSet<ContentReference>();
        private boolean updateRolloutPlans;
        private byte[] rolloutPlansHash;
        private List<ContentReference> removedContent = new ArrayList<ContentReference>();

        ContentDownloader(ModelNode startRoot, ModelNode endRoot, ModelNode hostModel) {
            this.startRoot = startRoot;
            this.endRoot = endRoot;
            this.serversByGroup = this.getOurServerGroups(hostModel);
        }

        void checkContent(ModelNode operation, PathAddress operationAddress) {
            block22: {
                PathElement firstElement;
                block21: {
                    if (!operation.get("operation").asString().equals("add") || operationAddress.size() == 0) {
                        return;
                    }
                    firstElement = operationAddress.getElement(0);
                    String contentType = firstElement.getKey();
                    if (contentType == null) {
                        return;
                    }
                    if (operationAddress.size() != 1) break block21;
                    switch (contentType) {
                        case "deployment": {
                            String deployment = firstElement.getValue();
                            Set<ContentReference> hashes = this.deploymentHashes.get(deployment);
                            if (hashes == null) {
                                hashes = new HashSet<ContentReference>();
                                this.deploymentHashes.put(deployment, hashes);
                                for (ModelNode contentItem : operation.get("content").asList()) {
                                    hashes.add(ModelContentReference.fromModelAddress((PathAddress)operationAddress, (byte[])contentItem.get("hash").asBytes()));
                                    if (!SyncServerStateOperationHandler.this.parameters.getHostControllerEnvironment().isBackupDomainFiles()) continue;
                                    this.relevantDeployments.add(firstElement.getValue());
                                }
                            }
                            this.makeExistingDeploymentUpdatedAffected(firstElement, operation);
                            break;
                        }
                        case "deployment-overlay": {
                            break;
                        }
                        case "management-client-content": {
                            if (firstElement.getValue().equals("rollout-plans")) {
                                this.updateRolloutPlans = true;
                                if (operation.hasDefined("hash")) {
                                    this.rolloutPlansHash = operation.get("hash").asBytes();
                                    this.requiredContent.add(ModelContentReference.fromModelAddress((PathAddress)operationAddress, (byte[])this.rolloutPlansHash));
                                    break;
                                }
                            }
                            break block22;
                        }
                        default: {
                            return;
                        }
                    }
                    break block22;
                }
                if (operationAddress.size() == 2) {
                    if (firstElement.getKey().equals("server-group") && this.serversByGroup.containsKey(firstElement.getValue())) {
                        PathElement secondElement = operationAddress.getElement(1);
                        if (secondElement.getKey().equals("deployment")) {
                            this.relevantDeployments.add(secondElement.getValue());
                            this.affectedGroups.add(firstElement.getValue());
                        }
                    } else if (firstElement.getKey().equals("deployment-overlay")) {
                        this.requiredContent.add(ModelContentReference.fromModelAddress((PathAddress)operationAddress, (byte[])operation.get("content").asBytes()));
                    }
                }
            }
        }

        private void makeExistingDeploymentUpdatedAffected(PathElement deploymentElement, ModelNode operation) {
            boolean changes;
            if (!this.startRoot.hasDefined(new String[]{deploymentElement.getKey(), deploymentElement.getValue()})) {
                return;
            }
            ModelNode deployment = this.startRoot.get(new String[]{deploymentElement.getKey(), deploymentElement.getValue()});
            List currentContents = deployment.get("content").asList();
            List newContents = operation.get("content").asList();
            boolean bl = changes = currentContents.size() != newContents.size();
            if (!changes) {
                HashSet<byte[]> currentHashes = new HashSet<byte[]>();
                for (ModelNode contentItem : currentContents) {
                    currentHashes.add(contentItem.get("hash").asBytes());
                }
                for (ModelNode contentItem : newContents) {
                    if (currentHashes.contains(contentItem.get("hash").asBytes())) continue;
                    changes = true;
                    break;
                }
            }
            if (changes && this.endRoot.hasDefined("server-group")) {
                for (Property serverGroup : this.endRoot.get("server-group").asPropertyList()) {
                    if (!serverGroup.getValue().hasDefined(new String[]{deploymentElement.getKey(), deploymentElement.getValue()})) continue;
                    this.affectedGroups.add(serverGroup.getName());
                    this.relevantDeployments.add(deploymentElement.getValue());
                }
            }
        }

        Set<String> pullDownContent(Resource domainRootResource) {
            for (String id : this.relevantDeployments) {
                Set<ContentReference> hashes = this.deploymentHashes.remove(id);
                if (hashes == null) continue;
                this.requiredContent.addAll(hashes);
            }
            for (ContentReference reference : this.requiredContent) {
                SyncServerStateOperationHandler.this.parameters.getFileRepository().getDeploymentFiles(reference);
                SyncServerStateOperationHandler.this.parameters.getContentRepository().addContentReference(reference);
            }
            if (this.updateRolloutPlans) {
                ModelNode hashNode;
                PathElement rolloutPlansElement = PathElement.pathElement((String)"management-client-content", (String)"rollout-plans");
                Resource existing = domainRootResource.removeChild(rolloutPlansElement);
                if (existing != null && (hashNode = existing.getModel().get("hash")).isDefined()) {
                    this.removedContent.add(new ContentReference(PathAddress.pathAddress((PathElement[])new PathElement[]{rolloutPlansElement}).toCLIStyleString(), hashNode.asBytes()));
                }
                ManagedDMRContentTypeResource rolloutPlansResource = new ManagedDMRContentTypeResource(PathAddress.pathAddress((PathElement[])new PathElement[]{rolloutPlansElement}), "rollout-plan", this.rolloutPlansHash, SyncServerStateOperationHandler.this.parameters.getContentRepository());
                domainRootResource.registerChild(rolloutPlansElement, (Resource)rolloutPlansResource);
            }
            HashSet<String> servers = new HashSet<String>();
            for (String group : this.affectedGroups) {
                if (!this.serversByGroup.containsKey(group)) continue;
                servers.addAll((Collection<String>)this.serversByGroup.get(group));
            }
            return servers;
        }

        private Map<String, Set<String>> getOurServerGroups(ModelNode hostModel) {
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            if (hostModel.hasDefined("server-config")) {
                for (Property config : hostModel.get("server-config").asPropertyList()) {
                    String group = config.getValue().get("group").asString();
                    HashSet<String> servers = (HashSet<String>)result.get(group);
                    if (servers == null) {
                        servers = new HashSet<String>();
                        result.put(group, servers);
                    }
                    servers.add(config.getName());
                }
            }
            return result;
        }
    }

    private static enum SyncServerResultAction {
        RESTART_REQUIRED,
        RELOAD_REQUIRED;

    }
}

