/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.access.rbac;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.Caller;
import org.jboss.as.controller.access.Environment;
import org.jboss.as.controller.access.JmxAction;
import org.jboss.as.controller.access.JmxTarget;
import org.jboss.as.controller.access.TargetAttribute;
import org.jboss.as.controller.access.TargetResource;
import org.jboss.as.controller.access.rbac.RoleMapper;
import org.jboss.as.controller.access.rbac.StandardRole;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RunAsRoleMapper
implements RoleMapper {
    private final RoleMapper realRoleMapper;

    public RunAsRoleMapper(RoleMapper realRoleMapper) {
        this.realRoleMapper = realRoleMapper;
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetAttribute attribute) {
        Set<String> runAsRoles = RunAsRoleMapper.getOperationHeaderRoles(action.getOperation());
        return this.mapRoles(caller, this.realRoleMapper.mapRoles(caller, callEnvironment, action, attribute), runAsRoles, true);
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Action action, TargetResource resource) {
        Set<String> runAsRoles = RunAsRoleMapper.getOperationHeaderRoles(action.getOperation());
        return this.mapRoles(caller, this.realRoleMapper.mapRoles(caller, callEnvironment, action, resource), runAsRoles, true);
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, JmxAction action, JmxTarget target) {
        return this.realRoleMapper.mapRoles(caller, callEnvironment, action, target);
    }

    @Override
    public Set<String> mapRoles(Caller caller, Environment callEnvironment, Set<String> operationHeaderRoles) {
        return this.mapRoles(caller, this.realRoleMapper.mapRoles(caller, callEnvironment, null), operationHeaderRoles, false);
    }

    @Override
    public boolean canRunAs(Set<String> mappedRoles, String runAsRole) {
        return false;
    }

    public static Set<String> getOperationHeaderRoles(ModelNode operation) {
        ModelNode headers;
        Set<Object> result = null;
        if (operation.hasDefined("operation-headers") && (headers = operation.get("operation-headers")).hasDefined("roles")) {
            ModelNode rolesNode = headers.get("roles");
            if (rolesNode.getType() == ModelType.STRING) {
                rolesNode = RunAsRoleMapper.parseRolesString(rolesNode.asString());
            }
            if (rolesNode.getType() == ModelType.STRING) {
                result = Collections.singleton(RunAsRoleMapper.getRoleFromText(rolesNode.asString()));
            } else {
                result = new HashSet();
                for (ModelNode role : rolesNode.asList()) {
                    result.add(RunAsRoleMapper.getRoleFromText(role.asString()));
                }
            }
        }
        return result;
    }

    private static ModelNode parseRolesString(String raw) {
        String trimmed = raw.trim();
        if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
            try {
                return ModelNode.fromString((String)trimmed);
            }
            catch (Exception exception) {
                trimmed = trimmed.substring(1, trimmed.length() - 1);
            }
        }
        if (trimmed.contains(",")) {
            String[] split;
            ModelNode result = new ModelNode().setEmptyList();
            for (String item : split = trimmed.split(",")) {
                result.add(item.trim());
            }
            return result;
        }
        return new ModelNode(trimmed);
    }

    private Set<String> mapRoles(Caller caller, Set<String> currentRoles, Set<String> runAsRoles, boolean sanitized) {
        Set<String> result = currentRoles;
        if (runAsRoles != null) {
            HashSet<String> roleSet = new HashSet<String>();
            for (String role : runAsRoles) {
                String requestedRole = sanitized ? role : RunAsRoleMapper.getRoleFromText(role);
                if (!this.realRoleMapper.canRunAs(currentRoles, requestedRole)) continue;
                roleSet.add(requestedRole);
            }
            if (!roleSet.isEmpty()) {
                result = Collections.unmodifiableSet(roleSet);
                if (ControllerLogger.ACCESS_LOGGER.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder("User '").append(caller.getName()).append("' Mapped to requested roles { ");
                    for (String current : result) {
                        sb.append("'").append(current).append("' ");
                    }
                    sb.append("}");
                    ControllerLogger.ACCESS_LOGGER.trace(sb.toString());
                }
            }
        }
        return result;
    }

    private static String getRoleFromText(String text) {
        try {
            StandardRole standardRole = StandardRole.valueOf(text.toUpperCase(Locale.ENGLISH));
            return standardRole.toString();
        }
        catch (Exception e) {
            return text;
        }
    }
}

