/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance;

import io.smallrye.faulttolerance.ExecutorFactory;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;

public class FaultToleranceContainerExecutorFactory
implements ExecutorFactory {
    private static final int KEEP_ALIVE_TIME = 600;

    public ExecutorService createCoreExecutor(int size) {
        return new ThreadPoolExecutor(1, size, 600L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.getThreadFactory());
    }

    public ExecutorService createExecutor(int coreSize, int size) {
        return new ThreadPoolExecutor(coreSize, size, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.getThreadFactory());
    }

    public ScheduledExecutorService createTimeoutExecutor(int size) {
        return Executors.newScheduledThreadPool(size, this.getThreadFactory());
    }

    private ThreadFactory getThreadFactory() {
        try {
            InitialContext initialContext = new InitialContext();
            return (ManagedThreadFactory)initialContext.lookup("java:jboss/ee/concurrency/factory/default");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int priority() {
        return 10;
    }
}

