/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.util.List;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.vfs.VirtualFile;

public class EjbJarDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final DotName STATELESS = DotName.createSimple((String)"jakarta.ejb.Stateless");
    private static final DotName STATEFUL = DotName.createSimple((String)"jakarta.ejb.Stateful");
    private static final DotName MESSAGE_DRIVEN = DotName.createSimple((String)"jakarta.ejb.MessageDriven");
    private static final DotName SINGLETON = DotName.createSimple((String)"jakarta.ejb.Singleton");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        if (deploymentRoot.getRoot().getChild("META-INF/application.xml").exists()) {
            return;
        }
        List potentialSubDeployments = deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot resourceRoot : potentialSubDeployments) {
            if (ModuleRootMarker.isModuleRoot((ResourceRoot)resourceRoot)) continue;
            VirtualFile ejbJarFile = resourceRoot.getRoot().getChild("META-INF/ejb-jar.xml");
            if (ejbJarFile.exists()) {
                SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
                ModuleRootMarker.mark((ResourceRoot)resourceRoot);
                continue;
            }
            Index index = (Index)resourceRoot.getAttachment(Attachments.ANNOTATION_INDEX);
            if (index == null || index.getAnnotations(STATEFUL).isEmpty() && index.getAnnotations(STATELESS).isEmpty() && index.getAnnotations(MESSAGE_DRIVEN).isEmpty() && index.getAnnotations(SINGLETON).isEmpty()) continue;
            SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
            ModuleRootMarker.mark((ResourceRoot)resourceRoot);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

