/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentracing;

import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.server.OperationNameProvider;
import io.opentracing.contrib.jaxrs2.server.ServerTracingDynamicFeature;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@Provider
public class SmallRyeTracingDynamicFeature
implements DynamicFeature {
    private static final Logger logger = Logger.getLogger(SmallRyeTracingDynamicFeature.class.getName());
    private final ServerTracingDynamicFeature delegate;

    public SmallRyeTracingDynamicFeature() {
        Instance tracerInstance = CDI.current().select(Tracer.class, new Annotation[0]);
        Config config = ConfigProvider.getConfig();
        Optional skipPattern = config.getOptionalValue("mp.opentracing.server.skip-pattern", String.class);
        Optional operationNameProvider = config.getOptionalValue("mp.opentracing.server.operation-name-provider", String.class);
        ServerTracingDynamicFeature.Builder builder = new ServerTracingDynamicFeature.Builder((Tracer)tracerInstance.get()).withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.ClassNameOperationName.newBuilder()).withTraceSerialization(false);
        if (skipPattern.isPresent()) {
            builder.withSkipPattern((String)skipPattern.get());
        }
        if (operationNameProvider.isPresent()) {
            if ("http-path".equalsIgnoreCase((String)operationNameProvider.get())) {
                builder.withOperationNameProvider((OperationNameProvider.Builder)OperationNameProvider.WildcardOperationName.newBuilder());
            } else if (!"class-method".equalsIgnoreCase((String)operationNameProvider.get())) {
                logger.warning("Provided operation name does not match http-path or class-method. Using default class-method.");
            }
        }
        this.delegate = builder.build();
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        this.delegate.configure(resourceInfo, context);
    }
}

