/*
 * Decompiled with CFR 0.152.
 */
package jakarta.ws.rs.client;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.FactoryFinder;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import java.net.URL;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public abstract class ClientBuilder
implements Configurable<ClientBuilder> {
    public static final String JAXRS_DEFAULT_CLIENT_BUILDER_PROPERTY = "jakarta.ws.rs.client.ClientBuilder";
    private static final String JAXRS_DEFAULT_CLIENT_BUILDER = "org.glassfish.jersey.client.JerseyClientBuilder";

    protected ClientBuilder() {
    }

    public static ClientBuilder newBuilder() {
        try {
            Object delegate = FactoryFinder.find(JAXRS_DEFAULT_CLIENT_BUILDER_PROPERTY, JAXRS_DEFAULT_CLIENT_BUILDER, ClientBuilder.class);
            if (!(delegate instanceof ClientBuilder)) {
                final Class<ClientBuilder> pClass = ClientBuilder.class;
                String classnameAsResource = pClass.getName().replace('.', '/') + ".class";
                SecurityManager sm = System.getSecurityManager();
                ClassLoader loader = null;
                if (sm == null) {
                    loader = pClass.getClassLoader();
                    if (loader == null) {
                        loader = ClassLoader.getSystemClassLoader();
                    }
                } else {
                    loader = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                        @Override
                        public ClassLoader run() throws Exception {
                            ClassLoader cloader = pClass.getClassLoader();
                            if (cloader == null) {
                                cloader = ClassLoader.getSystemClassLoader();
                            }
                            return cloader;
                        }
                    });
                }
                URL targetTypeURL = loader.getResource(classnameAsResource);
                throw new LinkageError("ClassCastException: attempting to cast" + delegate.getClass().getClassLoader().getResource(classnameAsResource) + " to " + targetTypeURL);
            }
            return (ClientBuilder)delegate;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Client newClient() {
        return ClientBuilder.newBuilder().build();
    }

    public static Client newClient(Configuration configuration) {
        return ClientBuilder.newBuilder().withConfig(configuration).build();
    }

    public abstract ClientBuilder withConfig(Configuration var1);

    public abstract ClientBuilder sslContext(SSLContext var1);

    public abstract ClientBuilder keyStore(KeyStore var1, char[] var2);

    public ClientBuilder keyStore(KeyStore keyStore, String password) {
        return this.keyStore(keyStore, password.toCharArray());
    }

    public abstract ClientBuilder trustStore(KeyStore var1);

    public abstract ClientBuilder hostnameVerifier(HostnameVerifier var1);

    public abstract ClientBuilder executorService(ExecutorService var1);

    public abstract ClientBuilder scheduledExecutorService(ScheduledExecutorService var1);

    public abstract ClientBuilder connectTimeout(long var1, TimeUnit var3);

    public abstract ClientBuilder readTimeout(long var1, TimeUnit var3);

    public abstract Client build();
}

