/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlConfigurator
implements ProtocolStackConfigurator {
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private final List<ProtocolConfiguration> configuration = new ArrayList<ProtocolConfiguration>();
    protected static final Log log = LogFactory.getLog(XmlConfigurator.class);

    protected XmlConfigurator(List<ProtocolConfiguration> protocols) {
        this.configuration.addAll(protocols);
    }

    public static XmlConfigurator getInstance(InputStream stream) throws IOException {
        return XmlConfigurator.getInstance(stream, false);
    }

    public static XmlConfigurator getInstance(InputStream stream, boolean validate) throws IOException {
        return XmlConfigurator.parse(stream, validate);
    }

    public String getProtocolStackString(boolean convert) {
        StringBuilder buf = new StringBuilder();
        Iterator<ProtocolConfiguration> it = this.configuration.iterator();
        if (convert) {
            buf.append("<config>\n");
        }
        while (it.hasNext()) {
            ProtocolConfiguration d = it.next();
            if (convert) {
                buf.append("    <");
            }
            buf.append(d.getProtocolString(convert));
            if (convert) {
                buf.append("/>");
            }
            if (!it.hasNext()) continue;
            if (convert) {
                buf.append('\n');
                continue;
            }
            buf.append(':');
        }
        if (convert) {
            buf.append("\n</config>");
        }
        return buf.toString();
    }

    @Override
    public String getProtocolStackString() {
        return this.getProtocolStackString(false);
    }

    @Override
    public List<ProtocolConfiguration> getProtocolStack() {
        return this.configuration;
    }

    protected static XmlConfigurator parse(InputStream stream, boolean validate) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validate);
            factory.setNamespaceAware(validate);
            if (validate) {
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver((publicId, systemId) -> {
                if (systemId != null && systemId.startsWith("http://www.jgroups.org/schema/JGroups-")) {
                    String schemaName = systemId.substring("http://www.jgroups.org/".length());
                    InputStream schemaIs = XmlConfigurator.getAsInputStreamFromClassLoader(schemaName);
                    if (schemaIs == null) {
                        throw new IOException("Schema not found from classloader: " + schemaName);
                    }
                    InputSource source = new InputSource(schemaIs);
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
                return null;
            });
            final AtomicReference exceptionRef = new AtomicReference();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    log.warn(Util.getMessage("ParseFailure"), exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    exceptionRef.set(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    exceptionRef.set(exception);
                }
            });
            Document document = builder.parse(stream);
            if (exceptionRef.get() != null) {
                throw (SAXParseException)exceptionRef.get();
            }
            Element configElement = document.getDocumentElement();
            return XmlConfigurator.parse(configElement);
        }
        catch (Exception x) {
            throw new IOException(String.format(Util.getMessage("ParseError"), x.getLocalizedMessage()));
        }
    }

    private static InputStream getAsInputStreamFromClassLoader(String filename) {
        InputStream is;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = is = cl == null ? null : cl.getResourceAsStream(filename);
        if (is == null) {
            is = XmlConfigurator.class.getClassLoader().getResourceAsStream(filename);
        }
        return is;
    }

    protected static XmlConfigurator parse(Element root_element) throws Exception {
        return new XmlConfigurator(XmlConfigurator.parseProtocols(root_element));
    }

    public static List<ProtocolConfiguration> parseProtocols(Element root_element) throws Exception {
        String root_name = root_element.getNodeName().trim().toLowerCase();
        if (!"config".equals(root_name)) {
            throw new IOException("the configuration does not start with a <config> element: " + root_name);
        }
        ArrayList<ProtocolConfiguration> prot_data = new ArrayList<ProtocolConfiguration>();
        NodeList prots = root_element.getChildNodes();
        for (int i = 0; i < prots.getLength(); ++i) {
            Node node = prots.item(i);
            if (node.getNodeType() != 1) continue;
            Element tag = (Element)node;
            String protocol = tag.getTagName();
            HashMap<String, String> params = new HashMap<String, String>();
            NamedNodeMap attrs = tag.getAttributes();
            int attrLength = attrs.getLength();
            for (int a = 0; a < attrLength; ++a) {
                Attr attr = (Attr)attrs.item(a);
                String name = attr.getName();
                String value = attr.getValue();
                params.put(name, value);
            }
            ProtocolConfiguration cfg = new ProtocolConfiguration(protocol, params);
            prot_data.add(cfg);
            NodeList subnodes = node.getChildNodes();
            for (int j = 0; j < subnodes.getLength(); ++j) {
                Node subnode = subnodes.item(j);
                if (subnode.getNodeType() != 1) continue;
                cfg.addSubtree(subnode);
            }
        }
        return prot_data;
    }

    public static void main(String[] args) throws Exception {
        InputStream input;
        String input_file = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-file")) {
                XmlConfigurator.help();
                return;
            }
            input_file = args[++i];
        }
        if (input_file != null) {
            input = null;
            try {
                input = new FileInputStream(new File(input_file));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (input == null) {
                try {
                    input = new URL(input_file).openStream();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (input == null) {
                input = Thread.currentThread().getContextClassLoader().getResourceAsStream(input_file);
            }
        } else {
            throw new Exception("no input file given");
        }
        XmlConfigurator conf = XmlConfigurator.getInstance(input);
        String tmp = conf.getProtocolStackString();
        System.out.println("\n" + tmp);
    }

    private static String dump(Collection<ProtocolConfiguration> configs) {
        StringBuilder sb = new StringBuilder();
        String indent = "  ";
        sb.append("<config>\n");
        for (ProtocolConfiguration cfg : configs) {
            sb.append(indent).append("<").append(cfg.getProtocolName());
            Map<String, String> props = cfg.getProperties();
            if (props.isEmpty()) {
                sb.append(" />\n");
                continue;
            }
            sb.append("\n").append(indent).append(indent);
            for (Map.Entry<String, String> entry : props.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                key = XmlConfigurator.trim(key);
                val = XmlConfigurator.trim(val);
                sb.append(key).append("=\"").append(val).append("\" ");
            }
            sb.append(" />\n");
        }
        sb.append("</config>\n");
        return sb.toString();
    }

    private static String trim(String val) {
        StringBuilder retval = new StringBuilder();
        val = val.trim();
        while (true) {
            int index;
            if ((index = val.indexOf(10)) == -1) break;
            retval.append(val, 0, index);
            val = val.substring(index + 1);
        }
        retval.append(val);
        return retval.toString();
    }

    private static String inputAsString(InputStream input) throws IOException {
        int len = input.available();
        byte[] buf = new byte[len];
        input.read(buf, 0, len);
        return new String(buf);
    }

    public static String replace(String input, String expr, String replacement) {
        StringBuilder sb = new StringBuilder();
        int new_index = 0;
        int index = 0;
        int len = expr.length();
        int input_len = input.length();
        while (true) {
            if ((new_index = input.indexOf(expr, index)) == -1) break;
            sb.append(input, index, new_index);
            sb.append(replacement);
            index = new_index + len;
        }
        sb.append(input, index, input_len);
        return sb.toString();
    }

    static void help() {
        System.out.println("XmlConfigurator -file <input XML file>");
    }
}

