/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.external;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.array.Arrays2;
import org.wildfly.security.sasl.WildFlySasl;
import org.wildfly.security.sasl.external.ExternalSaslClient;

public final class ExternalSaslClientFactory
implements SaslClientFactory {
    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (this.getMechanismNames(props, false).length != 0) {
            for (String mechanism : mechanisms) {
                if (!"EXTERNAL".equals(mechanism)) continue;
                return new ExternalSaslClient(authorizationId);
            }
        }
        return null;
    }

    private String[] getMechanismNames(Map<String, ?> props, boolean query) {
        if (props == null) {
            props = Collections.emptyMap();
        }
        if ("true".equals(props.get("wildfly.sasl.mechanism-query-all")) && query) {
            return (String[])Arrays2.of((Object[])new String[]{"EXTERNAL"});
        }
        if ("true".equals(props.get("javax.security.sasl.policy.forward")) || "true".equals(props.get("javax.security.sasl.policy.credentials")) || "true".equals(props.get("javax.security.sasl.policy.noanonymous"))) {
            return WildFlySasl.NO_NAMES;
        }
        return (String[])Arrays2.of((Object[])new String[]{"EXTERNAL"});
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return this.getMechanismNames(props, true);
    }
}

