/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

public class OptionalClaimTypeProducer {
    private static Logger log = Logger.getLogger(OptionalClaimTypeProducer.class);
    @Inject
    JsonWebToken currentToken;

    @Produces
    @Claim(value="")
    public Optional<String> getOptionalString(InjectionPoint ip) {
        log.debugf("getOptionalString(%s)", (Object)ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return this.currentToken.claim(RawClaimTypeProducer.getName(ip));
    }

    @Produces
    @Claim(value="")
    public Optional<Set<String>> getOptionalStringSet(InjectionPoint ip) {
        log.debugf("getOptionalStringSet(%s)", (Object)ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return this.currentToken.claim(RawClaimTypeProducer.getName(ip));
    }

    @Produces
    @Claim(value="")
    public Optional<Long> getOptionalLong(InjectionPoint ip) {
        log.debugf("getOptionalLong(%s)", (Object)ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return this.currentToken.claim(RawClaimTypeProducer.getName(ip));
    }

    @Produces
    @Claim(value="")
    public Optional<Boolean> getOptionalBoolean(InjectionPoint ip) {
        log.debugf("getOptionalBoolean(%s)", (Object)ip);
        if (this.currentToken == null) {
            return Optional.empty();
        }
        return this.currentToken.claim(RawClaimTypeProducer.getName(ip));
    }
}

