/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jaxrs2.server;

import io.opentracing.Span;
import io.opentracing.contrib.jaxrs2.internal.URIUtils;
import io.opentracing.tag.Tags;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;

public interface ServerSpanDecorator {
    public static final ServerSpanDecorator STANDARD_TAGS = new ServerSpanDecorator(){

        @Override
        public void decorateRequest(ContainerRequestContext requestContext, Span span) {
            Tags.COMPONENT.set(span, "jaxrs");
            Tags.HTTP_METHOD.set(span, requestContext.getMethod());
            String url = URIUtils.url(requestContext.getUriInfo().getRequestUri());
            if (url != null) {
                Tags.HTTP_URL.set(span, url);
            }
        }

        @Override
        public void decorateResponse(ContainerResponseContext responseContext, Span span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(responseContext.getStatus()));
        }
    };

    public void decorateRequest(ContainerRequestContext var1, Span var2);

    public void decorateResponse(ContainerResponseContext var1, Span var2);
}

