/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component;

import jakarta.ejb.TimerService;
import jakarta.ejb.TransactionAttributeType;
import jakarta.ejb.TransactionManagementType;
import jakarta.transaction.TransactionSynchronizationRegistry;
import jakarta.transaction.UserTransaction;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewDescription;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.EJBViewConfiguration;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.EjbHomeViewDescription;
import org.jboss.as.ejb3.component.MethodIntf;
import org.jboss.as.ejb3.component.MethodTransactionAttributeKey;
import org.jboss.as.ejb3.component.interceptors.ShutDownInterceptorFactory;
import org.jboss.as.ejb3.component.messagedriven.MessageDrivenComponentDescription;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.security.EJBSecurityMetaData;
import org.jboss.as.ejb3.suspend.EJBSuspendHandlerService;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.Interceptors;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.transaction.client.LocalUserTransaction;

public class EJBComponentCreateService
extends BasicComponentCreateService {
    private final Map<MethodTransactionAttributeKey, TransactionAttributeType> txAttrs;
    private final Map<MethodTransactionAttributeKey, Boolean> txExplicitAttrs;
    private final Map<MethodTransactionAttributeKey, Integer> txTimeouts;
    private final TransactionManagementType transactionManagementType;
    private final ApplicationExceptions applicationExceptions;
    private final Map<String, ServiceName> viewServices;
    private final EJBSecurityMetaData securityMetaData;
    private final TimerService timerService;
    private final Map<Method, InterceptorFactory> timeoutInterceptors;
    private final Method timeoutMethod;
    private final ServiceName ejbLocalHome;
    private final ServiceName ejbHome;
    private final ServiceName ejbObject;
    private final ServiceName ejbLocalObject;
    private final String applicationName;
    private final String earApplicationName;
    private final String moduleName;
    private final String distinctName;
    private final String policyContextID;
    private final InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistryValue = new InjectedValue();
    private final InjectedValue<ServerSecurityManager> serverSecurityManagerInjectedValue = new InjectedValue();
    private final InjectedValue<ControlPoint> controlPoint = new InjectedValue();
    private final InjectedValue<AtomicBoolean> exceptionLoggingEnabled = new InjectedValue();
    private final InjectedValue<SecurityDomain> securityDomain = new InjectedValue();
    private final InjectedValue<Function> identityOutflowFunction = new InjectedValue();
    private final InjectedValue<EJBSuspendHandlerService> ejbSuspendHandler = new InjectedValue();
    private final ShutDownInterceptorFactory shutDownInterceptorFactory;
    private final boolean jaccRequired;
    private final boolean securityRequired;
    private final EJBComponentDescription componentDescription;

    public EJBComponentCreateService(ComponentConfiguration componentConfiguration, ApplicationExceptions applicationExceptions) {
        super(componentConfiguration);
        this.applicationExceptions = applicationExceptions;
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        this.transactionManagementType = ejbComponentDescription.getTransactionManagementType();
        this.timerService = ejbComponentDescription.getTimerService();
        this.policyContextID = ejbComponentDescription.getPolicyContextID();
        if (this.transactionManagementType.equals((Object)TransactionManagementType.CONTAINER)) {
            this.txAttrs = new HashMap<MethodTransactionAttributeKey, TransactionAttributeType>();
            this.txTimeouts = new HashMap<MethodTransactionAttributeKey, Integer>();
            this.txExplicitAttrs = new HashMap<MethodTransactionAttributeKey, Boolean>();
        } else {
            this.txAttrs = null;
            this.txTimeouts = null;
            this.txExplicitAttrs = null;
        }
        this.securityMetaData = new EJBSecurityMetaData(componentConfiguration);
        if (ejbComponentDescription.isTimerServiceRequired()) {
            IdentityHashMap<Method, InterceptorFactory> timeoutInterceptors = new IdentityHashMap<Method, InterceptorFactory>();
            for (Method method : componentConfiguration.getDefinedComponentMethods()) {
                if ((ejbComponentDescription.getTimeoutMethod() == null || !ejbComponentDescription.getTimeoutMethod().equals(method)) && !ejbComponentDescription.getScheduleMethods().containsKey(method)) continue;
                InterceptorFactory interceptorFactory = Interceptors.getChainedInterceptorFactory((Collection)componentConfiguration.getAroundTimeoutInterceptors(method));
                timeoutInterceptors.put(method, interceptorFactory);
            }
            this.timeoutInterceptors = timeoutInterceptors;
        } else {
            this.timeoutInterceptors = Collections.emptyMap();
        }
        List views = componentConfiguration.getViews();
        if (views != null) {
            for (Object view : views) {
                EJBViewConfiguration ejbView = (EJBViewConfiguration)((Object)view);
                MethodIntf viewType = ejbView.getMethodIntf();
                for (Method method : view.getProxyFactory().getCachedMethods()) {
                    if (!Modifier.isPublic(method.getModifiers())) continue;
                    Method componentMethod = EJBComponentCreateService.getComponentMethod(componentConfiguration, method.getName(), method.getParameterTypes());
                    if (componentMethod != null) {
                        this.processTxAttr(ejbComponentDescription, viewType, componentMethod);
                        continue;
                    }
                    this.processTxAttr(ejbComponentDescription, viewType, method);
                }
            }
        }
        this.timeoutMethod = ejbComponentDescription.getTimeoutMethod();
        HashSet lifeCycle = new HashSet(componentConfiguration.getLifecycleMethods());
        for (Method method : componentConfiguration.getComponentClass().getMethods()) {
            this.processTxAttr(ejbComponentDescription, MethodIntf.BEAN, method);
            lifeCycle.remove(method);
        }
        for (Method method : lifeCycle) {
            if (!method.getDeclaringClass().equals(componentConfiguration.getComponentClass())) continue;
            this.processTxAttr(ejbComponentDescription, MethodIntf.BEAN, method);
        }
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        for (ViewDescription view : componentConfiguration.getComponentDescription().getViews()) {
            viewServices.put(view.getViewClassName(), view.getServiceName());
        }
        this.viewServices = viewServices;
        EjbHomeViewDescription localHome = ejbComponentDescription.getEjbLocalHomeView();
        this.ejbLocalHome = localHome == null ? null : ejbComponentDescription.getEjbLocalHomeView().getServiceName();
        EjbHomeViewDescription home = ejbComponentDescription.getEjbHomeView();
        this.ejbHome = home == null ? null : home.getServiceName();
        EJBViewDescription ejbObject = ejbComponentDescription.getEjbRemoteView();
        this.ejbObject = ejbObject == null ? null : ejbObject.getServiceName();
        EJBViewDescription ejbLocalObject = ejbComponentDescription.getEjbLocalView();
        this.ejbLocalObject = ejbLocalObject == null ? null : ejbLocalObject.getServiceName();
        this.applicationName = componentConfiguration.getApplicationName();
        this.earApplicationName = componentConfiguration.getComponentDescription().getModuleDescription().getEarApplicationName();
        this.moduleName = componentConfiguration.getModuleName();
        this.distinctName = componentConfiguration.getComponentDescription().getModuleDescription().getDistinctName();
        this.shutDownInterceptorFactory = ejbComponentDescription.getShutDownInterceptorFactory();
        this.securityRequired = ejbComponentDescription.isSecurityRequired();
        this.jaccRequired = ejbComponentDescription.requiresJacc();
        this.componentDescription = ejbComponentDescription;
    }

    protected boolean requiresInterceptors(Method method, ComponentConfiguration componentConfiguration) {
        if (super.requiresInterceptors(method, componentConfiguration)) {
            return true;
        }
        EJBComponentDescription ejbComponentDescription = (EJBComponentDescription)componentConfiguration.getComponentDescription();
        return ejbComponentDescription.getTimeoutMethod() != null && ejbComponentDescription.getTimeoutMethod().equals(method) || ejbComponentDescription.getScheduleMethods().containsKey(method);
    }

    private static Method getComponentMethod(ComponentConfiguration componentConfiguration, String name, Class<?>[] parameterTypes) {
        try {
            return componentConfiguration.getComponentClass().getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    Map<MethodTransactionAttributeKey, TransactionAttributeType> getTxAttrs() {
        return this.txAttrs;
    }

    Map<MethodTransactionAttributeKey, Boolean> getExplicitTxAttrs() {
        return this.txExplicitAttrs;
    }

    Map<MethodTransactionAttributeKey, Integer> getTxTimeouts() {
        return this.txTimeouts;
    }

    TransactionManagementType getTransactionManagementType() {
        return this.transactionManagementType;
    }

    ApplicationExceptions getApplicationExceptions() {
        return this.applicationExceptions;
    }

    EJBComponentDescription getComponentDescription() {
        return this.componentDescription;
    }

    protected void processTxAttr(EJBComponentDescription ejbComponentDescription, MethodIntf methodIntf, Method method) {
        Integer txTimeout;
        if (this.getTransactionManagementType().equals((Object)TransactionManagementType.BEAN)) {
            return;
        }
        MethodIntf defaultMethodIntf = ejbComponentDescription instanceof MessageDrivenComponentDescription ? MethodIntf.MESSAGE_ENDPOINT : MethodIntf.BEAN;
        TransactionAttributeType txAttr = ejbComponentDescription.getTransactionAttributes().getAttribute(methodIntf, method, defaultMethodIntf);
        MethodTransactionAttributeKey key = new MethodTransactionAttributeKey(methodIntf, MethodIdentifier.getIdentifierForMethod((Method)method));
        if (txAttr != null) {
            this.txAttrs.put(key, txAttr);
            this.txExplicitAttrs.put(key, ejbComponentDescription.getTransactionAttributes().isMethodLevel(methodIntf, method, defaultMethodIntf));
        }
        if ((txTimeout = ejbComponentDescription.getTransactionTimeouts().getAttribute(methodIntf, method, defaultMethodIntf)) != null) {
            this.txTimeouts.put(key, txTimeout);
        }
    }

    public Map<String, ServiceName> getViewServices() {
        return this.viewServices;
    }

    public EJBSecurityMetaData getSecurityMetaData() {
        return this.securityMetaData;
    }

    public Map<Method, InterceptorFactory> getTimeoutInterceptors() {
        return this.timeoutInterceptors;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    public ServiceName getEjbHome() {
        return this.ejbHome;
    }

    public ServiceName getEjbLocalHome() {
        return this.ejbLocalHome;
    }

    public ServiceName getEjbObject() {
        return this.ejbObject;
    }

    public ServiceName getEjbLocalObject() {
        return this.ejbLocalObject;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getEarApplicationName() {
        return this.earApplicationName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    UserTransaction getUserTransaction() {
        return LocalUserTransaction.getInstance();
    }

    Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
        return this.transactionSynchronizationRegistryValue;
    }

    TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistryValue.getValue();
    }

    public Injector<EJBSuspendHandlerService> getEJBSuspendHandlerInjector() {
        return this.ejbSuspendHandler;
    }

    EJBSuspendHandlerService getEJBSuspendHandler() {
        return (EJBSuspendHandlerService)this.ejbSuspendHandler.getValue();
    }

    ServerSecurityManager getServerSecurityManager() {
        return (ServerSecurityManager)this.serverSecurityManagerInjectedValue.getOptionalValue();
    }

    Injector<ServerSecurityManager> getServerSecurityManagerInjector() {
        return this.serverSecurityManagerInjectedValue;
    }

    public ControlPoint getControlPoint() {
        return (ControlPoint)this.controlPoint.getOptionalValue();
    }

    public Injector<ControlPoint> getControlPointInjector() {
        return this.controlPoint;
    }

    public String getPolicyContextID() {
        return this.policyContextID;
    }

    InjectedValue<AtomicBoolean> getExceptionLoggingEnabledInjector() {
        return this.exceptionLoggingEnabled;
    }

    public AtomicBoolean getExceptionLoggingEnabled() {
        return (AtomicBoolean)this.exceptionLoggingEnabled.getValue();
    }

    Injector<SecurityDomain> getSecurityDomainInjector() {
        return this.securityDomain;
    }

    public SecurityDomain getSecurityDomain() {
        return (SecurityDomain)this.securityDomain.getOptionalValue();
    }

    public boolean isEnableJacc() {
        return this.jaccRequired;
    }

    Injector<Function> getIdentityOutflowFunctionInjector() {
        return this.identityOutflowFunction;
    }

    public Function getIdentityOutflowFunction() {
        return (Function)this.identityOutflowFunction.getOptionalValue();
    }

    public ShutDownInterceptorFactory getShutDownInterceptorFactory() {
        return this.shutDownInterceptorFactory;
    }

    public boolean isSecurityRequired() {
        return this.securityRequired;
    }
}

