/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import org.hibernate.search.spatial.Coordinates;

public final class Point
implements Coordinates {
    private final double latitude;
    private final double longitude;

    public static Point fromDegrees(double latitude, double longitude) {
        return new Point(Point.normalizeLatitude(latitude), Point.normalizeLongitude(longitude));
    }

    public static Point fromCoordinates(Coordinates center) {
        if (center instanceof Point) {
            return (Point)center;
        }
        return Point.fromDegrees(center.getLatitude(), center.getLongitude());
    }

    public static Point fromDegreesInclusive(double latitude, double longitude) {
        return new Point(Point.normalizeLatitude(latitude), Point.normalizeLongitudeInclusive(longitude));
    }

    public static double normalizeLongitude(double longitude) {
        if (longitude == -180.0) {
            return 180.0;
        }
        return Point.normalizeLongitudeInclusive(longitude);
    }

    public static double normalizeLongitudeInclusive(double longitude) {
        if (longitude < -180.0 || longitude > 180.0) {
            double _longitude = (longitude + 180.0) % 360.0;
            _longitude = _longitude < 0.0 ? (_longitude += 180.0) : (_longitude -= 180.0);
            return _longitude;
        }
        return longitude;
    }

    public static double normalizeLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            double _latitude = Math.abs((latitude + 90.0) % 360.0);
            if (_latitude > 180.0) {
                _latitude = 360.0 - _latitude;
            }
            return _latitude -= 90.0;
        }
        return latitude;
    }

    public static Point fromRadians(double latitude, double longitude) {
        return Point.fromDegrees(latitude * 57.29577951308232, longitude * 57.29577951308232);
    }

    private Point(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Point computeDestination(double distance, double heading) {
        double headingRadian = heading * (Math.PI / 180);
        double destinationLatitudeRadian = Math.asin(Math.sin(this.getLatitudeRad()) * Math.cos(distance / 6371.0) + Math.cos(this.getLatitudeRad()) * Math.sin(distance / 6371.0) * Math.cos(headingRadian));
        double destinationLongitudeRadian = this.getLongitudeRad() + Math.atan2(Math.sin(headingRadian) * Math.sin(distance / 6371.0) * Math.cos(this.getLatitudeRad()), Math.cos(distance / 6371.0) - Math.sin(this.getLatitudeRad()) * Math.sin(destinationLatitudeRadian));
        return Point.fromRadians(destinationLatitudeRadian, destinationLongitudeRadian);
    }

    public double getDistanceTo(Point other) {
        return this.getDistanceTo(other.getLatitude(), other.getLongitude());
    }

    public double getDistanceTo(double latitude, double longitude) {
        double destinationLatitudeRadians = Point.normalizeLatitude(latitude) * (Math.PI / 180);
        double destinationLongitudeRadians = Point.normalizeLongitude(longitude) * (Math.PI / 180);
        double dLat = (destinationLatitudeRadians - this.getLatitudeRad()) / 2.0;
        double dLon = (destinationLongitudeRadians - this.getLongitudeRad()) / 2.0;
        double a = Math.pow(Math.sin(dLat), 2.0) + Math.pow(Math.sin(dLon), 2.0) * Math.cos(this.getLatitudeRad()) * Math.cos(destinationLatitudeRadians);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c * 6371.0;
    }

    @Override
    public Double getLatitude() {
        return this.latitude;
    }

    @Override
    public Double getLongitude() {
        return this.longitude;
    }

    public double getLatitudeRad() {
        return this.latitude * (Math.PI / 180);
    }

    public double getLongitudeRad() {
        return this.longitude * (Math.PI / 180);
    }

    public int hashCode() {
        return 31 * Double.hashCode(this.latitude) + Double.hashCode(this.longitude);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point) {
            Point other = (Point)obj;
            return this.latitude == other.latitude && this.longitude == other.longitude;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Point");
        sb.append("{latitude=").append(this.latitude);
        sb.append(", longitude=").append(this.longitude);
        sb.append('}');
        return sb.toString();
    }
}

