/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.logging;

import java.net.URL;
import java.net.UnknownHostException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYCLJG", length=4)
public interface JGroupsLogger
extends BasicLogger {
    public static final String ROOT_LOGGER_CATEGORY = "org.jboss.as.clustering.jgroups";
    public static final JGroupsLogger ROOT_LOGGER = (JGroupsLogger)Logger.getMessageLogger(JGroupsLogger.class, (String)"org.jboss.as.clustering.jgroups");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Activating JGroups subsystem. JGroups version %s")
    public void activatingSubsystem(String var1);

    @Message(id=7, value="Failed to parse %s")
    public String parserFailure(URL var1);

    @Message(id=8, value="Failed to locate %s")
    public String notFound(String var1);

    @Message(id=10, value="Transport for stack %s is not defined. Please specify both a transport and protocol list, either as optional parameters to add() or via batching.")
    public OperationFailedException transportNotDefined(String var1);

    @Message(id=15, value="Unknown metric %s")
    public String unknownMetric(String var1);

    @Message(id=16, value="Unable to load protocol class %s")
    public OperationFailedException unableToLoadProtocolClass(String var1);

    @Message(id=17, value="Privileged access exception on attribute/method %s")
    public String privilegedAccessExceptionForAttribute(String var1);

    @Message(id=21, value="Attributes referencing threads subsystem can only be used to support older slaves in the domain.")
    public String threadsAttributesUsedInRuntime();

    @Message(id=22, value="%s entry not found in configured key store")
    public IllegalArgumentException keyEntryNotFound(String var1);

    @Message(id=23, value="%s key store entry is not of the expected type: %s")
    public IllegalArgumentException unexpectedKeyStoreEntryType(String var1, String var2);

    @Message(id=24, value="%s key store entry does not contain a secret key")
    public IllegalArgumentException secretKeyStoreEntryExpected(String var1);

    @Message(id=25, value="Configured credential source does not reference a clear-text password credential")
    public IllegalArgumentException unexpectedCredentialSource();

    @Message(id=28, value="Could not resolve destination address for outbound socket binding named '%s'")
    public IllegalArgumentException failedToResolveSocketBinding(@Cause UnknownHostException var1, OutboundSocketBinding var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=30, value="Protocol %s is obsolete and will be auto-updated to %s")
    public void legacyProtocol(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=31, value="Ignoring unrecognized %s property: %s")
    public void unrecognizedProtocolProperty(String var1, String var2);
}

