/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueBoolean
extends Value {
    public static final int PRECISION = 1;
    public static final int DISPLAY_SIZE = 5;
    public static final ValueBoolean TRUE = new ValueBoolean(true);
    public static final ValueBoolean FALSE = new ValueBoolean(false);
    private final boolean value;

    private ValueBoolean(boolean bl) {
        this.value = bl;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public String getString() {
        return this.value ? "TRUE" : "FALSE";
    }

    @Override
    public Value negate() {
        return this.value ? FALSE : TRUE;
    }

    @Override
    public boolean getBoolean() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueBoolean valueBoolean = (ValueBoolean)value;
        return Boolean.compare(this.value, valueBoolean.value);
    }

    @Override
    public long getPrecision() {
        return 1L;
    }

    @Override
    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBoolean(n, this.value);
    }

    public static ValueBoolean get(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Override
    public int getDisplaySize() {
        return 5;
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }
}

