/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.runtime.context;

import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.Metric;
import jakarta.batch.runtime.context.StepContext;
import jakarta.enterprise.context.spi.Contextual;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jberet._private.BatchLogger;
import org.jberet.creation.JobScopedContextImpl;
import org.jberet.job.model.Step;
import org.jberet.runtime.AbstractStepExecution;
import org.jberet.runtime.JobExecutionImpl;
import org.jberet.runtime.PartitionExecutionImpl;
import org.jberet.runtime.StepExecutionImpl;
import org.jberet.runtime.context.AbstractContext;
import org.jberet.util.BatchUtil;
import org.wildfly.security.manager.WildFlySecurityManager;

public class StepContextImpl
extends AbstractContext
implements StepContext,
Cloneable {
    private Step step;
    private AbstractStepExecution stepExecution;
    private StepExecutionImpl originalStepExecution;
    private Boolean allowStartIfComplete;
    private ConcurrentMap<Contextual<?>, JobScopedContextImpl.ScopedInstance<?>> partitionScopedBeans;

    public StepContextImpl(Step step, AbstractContext[] outerContexts) {
        super(step.getId(), outerContexts);
        this.step = step;
        this.classLoader = this.getJobContext().getClassLoader();
        this.stepExecution = this.getJobContext().jobRepository.createStepExecution(this.id);
        JobExecutionImpl originalToRestart = this.getJobContext().originalToRestart;
        if (originalToRestart != null) {
            this.originalStepExecution = this.getJobContext().getJobRepository().findOriginalStepExecutionForRestart(this.id, originalToRestart, this.classLoader);
            if (this.originalStepExecution != null) {
                if (this.originalStepExecution.getBatchStatus() == BatchStatus.COMPLETED) {
                    this.allowStartIfComplete = Boolean.valueOf(step.getAllowStartIfComplete());
                    if (this.allowStartIfComplete == Boolean.FALSE) {
                        this.stepExecution = this.originalStepExecution;
                        return;
                    }
                }
                if (this.originalStepExecution.getPersistentUserData() != null) {
                    this.stepExecution.setPersistentUserData(this.originalStepExecution.getPersistentUserData());
                }
                this.stepExecution.setReaderCheckpointInfo(this.originalStepExecution.getReaderCheckpointInfo());
                this.stepExecution.setWriterCheckpointInfo(this.originalStepExecution.getWriterCheckpointInfo());
            } else {
                BatchLogger.LOGGER.couldNotFindOriginalStepToRestart(this.stepExecution.getStepExecutionId(), this.getStepName());
            }
        }
        this.stepExecution.setBatchStatus(BatchStatus.STARTING);
    }

    public StepContextImpl(Step step, AbstractStepExecution stepExecution, AbstractContext[] outerContexts) {
        super(step.getId(), outerContexts);
        this.step = step;
        this.classLoader = this.getJobContext().getClassLoader();
        this.stepExecution = stepExecution;
        this.partitionScopedBeans = new ConcurrentHashMap();
    }

    @Override
    public StepContextImpl clone() {
        StepContextImpl c = null;
        try {
            c = (StepContextImpl)super.clone();
            c.stepExecution = new PartitionExecutionImpl(this.stepExecution);
            c.outerContexts = new AbstractContext[this.outerContexts.length];
            c.outerContexts[0] = this.getJobContext().clone();
            for (int i = 1; i < c.outerContexts.length; ++i) {
                c.outerContexts[i] = this.outerContexts[i];
            }
            c.step = WildFlySecurityManager.isChecking() ? AccessController.doPrivileged(new PrivilegedAction<Step>(){

                @Override
                public Step run() {
                    return BatchUtil.clone(StepContextImpl.this.step);
                }
            }) : BatchUtil.clone(this.step);
            c.partitionScopedBeans = new ConcurrentHashMap();
        }
        catch (CloneNotSupportedException e) {
            BatchLogger.LOGGER.failToClone(e, this, this.getJobContext().getJobName(), this.getStepName());
        }
        return c;
    }

    public Step getStep() {
        return this.step;
    }

    public AbstractStepExecution getStepExecution() {
        return this.stepExecution;
    }

    public Boolean getAllowStartIfComplete() {
        return this.allowStartIfComplete;
    }

    public String getStepName() {
        return this.step.getId();
    }

    @Override
    public BatchStatus getBatchStatus() {
        return this.stepExecution.getBatchStatus();
    }

    @Override
    public void setBatchStatus(BatchStatus status) {
        this.stepExecution.setBatchStatus(status);
    }

    @Override
    public String getExitStatus() {
        return this.stepExecution.getExitStatus();
    }

    @Override
    public void setExitStatus(String exitStatus) {
        this.stepExecution.setExitStatus(exitStatus);
    }

    public long getStepExecutionId() {
        return this.stepExecution.getStepExecutionId();
    }

    public Properties getProperties() {
        return org.jberet.job.model.Properties.toJavaUtilProperties(this.step.getProperties());
    }

    public Serializable getPersistentUserData() {
        return this.stepExecution.getPersistentUserData();
    }

    public void setPersistentUserData(Serializable data) {
        this.stepExecution.setPersistentUserData(data);
    }

    public Exception getException() {
        return this.stepExecution.getException();
    }

    public void setException(Exception e) {
        this.stepExecution.setException(e);
    }

    public Metric[] getMetrics() {
        return this.stepExecution.getMetrics();
    }

    public void savePersistentData() {
        this.getJobContext().jobRepository.savePersistentData(this.getJobContext().jobExecution, this.stepExecution);
    }

    public StepExecutionImpl getOriginalStepExecution() {
        return this.originalStepExecution;
    }

    public ConcurrentMap<Contextual<?>, JobScopedContextImpl.ScopedInstance<?>> getPartitionScopedBeans() {
        return this.partitionScopedBeans;
    }
}

