/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ViewHandlingStrategy
extends ViewDeclarationLanguage {
    private static final Logger logger = FacesLogger.APPLICATION.getLogger();
    protected ApplicationAssociate associate;
    protected WebConfiguration webConfig;

    public ViewHandlingStrategy() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.webConfig = WebConfiguration.getInstance(ctx.getExternalContext());
        this.associate = ApplicationAssociate.getInstance(ctx.getExternalContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UIViewRoot restoreView(FacesContext ctx, String viewId) {
        ExternalContext extContext = ctx.getExternalContext();
        String mapping = Util.getFacesMapping(ctx);
        UIViewRoot viewRoot = null;
        if (extContext.getRequestPathInfo() == null && mapping != null && Util.isPrefixMapped(mapping)) {
            try {
                ctx.responseComplete();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Response Complete for" + viewId);
                }
                if (extContext.isResponseCommitted()) return viewRoot;
                extContext.redirect(extContext.getRequestContextPath());
                return viewRoot;
            }
            catch (IOException ioe) {
                throw new FacesException((Throwable)ioe);
            }
        } else {
            ViewHandler outerViewHandler = ctx.getApplication().getViewHandler();
            String renderKitId = outerViewHandler.calculateRenderKitId(ctx);
            return Util.getStateManager(ctx).restoreView(ctx, viewId, renderKitId);
        }
    }

    public UIViewRoot createView(FacesContext ctx, String viewId) {
        Util.notNull("context", ctx);
        UIViewRoot result = (UIViewRoot)ctx.getApplication().createComponent("jakarta.faces.ViewRoot");
        Locale locale = null;
        String renderKitId = null;
        if (ctx.getViewRoot() != null) {
            locale = ctx.getViewRoot().getLocale();
            renderKitId = ctx.getViewRoot().getRenderKitId();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created new view for " + viewId);
        }
        if (locale == null) {
            locale = ctx.getApplication().getViewHandler().calculateLocale(ctx);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Locale for this view as determined by calculateLocale " + locale.toString());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using locale from previous view " + locale.toString());
        }
        if (renderKitId == null) {
            renderKitId = ctx.getApplication().getViewHandler().calculateRenderKitId(ctx);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("RenderKitId for this view as determined by calculateRenderKitId " + renderKitId);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.fine("Using renderKitId from previous view " + renderKitId);
        }
        result.setLocale(locale);
        result.setRenderKitId(renderKitId);
        result.setViewId(viewId);
        return result;
    }

    public abstract boolean handlesViewId(String var1);
}

