/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.PathSegment;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class MatrixParamInjector
extends StringParameterInjector
implements ValueInjector {
    private boolean encode;

    public MatrixParamInjector(Class type, Type genericType, AccessibleObject target, String paramName, String defaultValue, boolean encode, Annotation[] annotations, ResteasyProviderFactory factory) {
        super(type, genericType, paramName, MatrixParam.class, defaultValue, target, annotations, factory);
        this.encode = encode;
    }

    @Override
    public Object inject(HttpRequest request, HttpResponse response) {
        ArrayList<String> values = new ArrayList<String>();
        if (this.encode) {
            for (PathSegment segment : request.getUri().getPathSegments(false)) {
                List list = (List)segment.getMatrixParameters().get((Object)this.paramName);
                if (list == null) continue;
                values.addAll(list);
            }
        } else {
            for (PathSegment segment : request.getUri().getPathSegments()) {
                List list = (List)segment.getMatrixParameters().get((Object)this.paramName);
                if (list == null) continue;
                values.addAll(list);
            }
        }
        if (values.size() == 0) {
            return this.extractValues(null);
        }
        return this.extractValues(values);
    }

    @Override
    protected void throwProcessingException(String message, Throwable cause) {
        throw new NotFoundException(message, cause);
    }

    @Override
    public Object inject() {
        throw new RuntimeException(Messages.MESSAGES.illegalToInjectMatrixParam());
    }
}

