/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.Encode;
import org.jboss.resteasy.util.FindAnnotation;
import org.jboss.resteasy.util.NoContent;

@Provider
@Produces(value={"application/x-www-form-urlencoded"})
@Consumes(value={"application/x-www-form-urlencoded"})
@ConstrainedTo(value=RuntimeType.CLIENT)
public class FormUrlEncodedProvider
implements MessageBodyReader<MultivaluedMap>,
MessageBodyWriter<MultivaluedMap> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultivaluedMap.class.equals(type);
    }

    public MultivaluedMap readFrom(Class<MultivaluedMap> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", this.getClass().getName());
        if (NoContent.isContentLengthZero(httpHeaders)) {
            return new MultivaluedMapImpl();
        }
        boolean encoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset == null) {
            charset = StandardCharsets.UTF_8.name();
        }
        if (encoded) {
            return FormUrlEncodedProvider.parseForm(entityStream, charset);
        }
        return Encode.decode(FormUrlEncodedProvider.parseForm(entityStream, charset), charset);
    }

    public static MultivaluedMap<String, String> parseForm(InputStream entityStream, String charset) throws IOException {
        String[] params;
        char[] buffer = new char[100];
        StringBuffer buf = new StringBuffer();
        if (charset == null) {
            charset = StandardCharsets.UTF_8.name();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream, charset));
        int wasRead = 0;
        do {
            if ((wasRead = reader.read(buffer, 0, 100)) <= 0) continue;
            buf.append(buffer, 0, wasRead);
        } while (wasRead > -1);
        String form = buf.toString();
        MultivaluedMapImpl<String, String> formData = new MultivaluedMapImpl<String, String>();
        if ("".equals(form)) {
            return formData;
        }
        for (String param : params = form.split("&")) {
            if (param.indexOf(61) >= 0) {
                String[] nv = param.split("=");
                String val = nv.length > 1 ? nv[1] : "";
                formData.add(nv[0], val);
                continue;
            }
            formData.add(param, "");
        }
        return formData;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultivaluedMap.class.isAssignableFrom(type);
    }

    public long getSize(MultivaluedMap stringStringMultivaluedMap, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(MultivaluedMap data, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : writeTo", this.getClass().getName());
        MultivaluedMap formData = data;
        String charset = (String)mediaType.getParameters().get("charset");
        if (charset == null) {
            charset = StandardCharsets.UTF_8.name();
        }
        boolean encoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baos, charset);
        boolean first = true;
        for (Map.Entry entry : formData.entrySet()) {
            String encodedName = (String)entry.getKey();
            if (!encoded) {
                encodedName = URLEncoder.encode((String)entry.getKey(), charset);
            }
            for (String value : (List)entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    writer.write("&");
                }
                if (!encoded) {
                    value = URLEncoder.encode(value, charset);
                }
                writer.write(encodedName);
                writer.write("=");
                writer.write(value);
            }
            writer.flush();
        }
        byte[] bytes = baos.toByteArray();
        entityStream.write(bytes);
    }
}

