/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.DefaultExecutorFactory;
import io.smallrye.faulttolerance.ExecutorFactory;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Singleton
public class ExecutorProvider {
    @Inject
    @ConfigProperty(name="io.smallrye.faulttolerance.globalThreadPoolSize", defaultValue="100")
    private Integer size;
    @Inject
    @ConfigProperty(name="io.smallrye.faulttolerance.timeoutExecutorThreads", defaultValue="5")
    private Integer timeoutExecutorSize;
    private ExecutorService globalExecutor;
    private ScheduledExecutorService timeoutExecutor;
    private ExecutorFactory executorFactory;
    private final List<ExecutorService> allExecutors = new ArrayList<ExecutorService>();

    @PostConstruct
    public void setUp() {
        if (this.size < 5) {
            throw new IllegalArgumentException("Please set the global thread pool size for a value larger than 5. ");
        }
        this.executorFactory = ExecutorProvider.executorProvider();
        this.globalExecutor = this.executorFactory.createCoreExecutor(this.size);
        this.timeoutExecutor = this.executorFactory.createTimeoutExecutor(this.timeoutExecutorSize);
        this.allExecutors.add(this.globalExecutor);
        this.allExecutors.add(this.timeoutExecutor);
    }

    @PreDestroy
    public void tearDown() {
        this.allExecutors.forEach(ExecutorService::shutdownNow);
        for (ExecutorService executor : this.allExecutors) {
            try {
                executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ExecutorService createAdHocExecutor(int size) {
        ExecutorService executor = this.executorFactory.createExecutor(size, size);
        this.allExecutors.add(executor);
        return executor;
    }

    public ExecutorService getGlobalExecutor() {
        return this.globalExecutor;
    }

    public ScheduledExecutorService getTimeoutExecutor() {
        return this.timeoutExecutor;
    }

    private static ExecutorFactory executorProvider() {
        ServiceLoader<ExecutorFactory> loader = ServiceLoader.load(ExecutorFactory.class);
        Iterator<ExecutorFactory> iterator = loader.iterator();
        ExecutorFactory maxPriorityProvider = new DefaultExecutorFactory();
        while (iterator.hasNext()) {
            ExecutorFactory next = iterator.next();
            if (next.priority() <= maxPriorityProvider.priority()) continue;
            maxPriorityProvider = next;
        }
        return maxPriorityProvider;
    }
}

