/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security;

import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.Account;
import io.undertow.servlet.handlers.ServletRequestContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;

public class AuditNotificationReceiver
implements NotificationReceiver {
    private final AuditManager auditManager;

    public AuditNotificationReceiver(AuditManager auditManager) {
        this.auditManager = auditManager;
    }

    public void handleNotification(SecurityNotification notification) {
        SecurityNotification.EventType event = notification.getEventType();
        if (event == SecurityNotification.EventType.AUTHENTICATED || event == SecurityNotification.EventType.FAILED_AUTHENTICATION) {
            ServletRequest hsr;
            AuditEvent auditEvent = new AuditEvent(event == SecurityNotification.EventType.AUTHENTICATED ? "Success" : "Failure");
            HashMap<String, String> ctxMap = new HashMap<String, String>();
            Account account = notification.getAccount();
            if (account != null) {
                ctxMap.put("principal", account.getPrincipal().getName());
            }
            ctxMap.put("message", notification.getMessage());
            ServletRequestContext src = (ServletRequestContext)notification.getExchange().getAttachment(ServletRequestContext.ATTACHMENT_KEY);
            if (src != null && (hsr = src.getServletRequest()) instanceof HttpServletRequest) {
                ctxMap.put("request", AuditNotificationReceiver.deriveUsefulInfo((HttpServletRequest)hsr));
            }
            ctxMap.put("Source", this.getClass().getCanonicalName());
            auditEvent.setContextMap(ctxMap);
            this.auditManager.audit(auditEvent);
        }
    }

    private static String deriveUsefulInfo(HttpServletRequest httpRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(httpRequest.getContextPath());
        sb.append(":cookies=").append(Arrays.toString(httpRequest.getCookies())).append(":headers=");
        Enumeration en = httpRequest.getHeaderNames();
        while (en.hasMoreElements()) {
            String headerName = (String)en.nextElement();
            sb.append(headerName).append("=");
            if (headerName.contains("authorization")) continue;
            sb.append(httpRequest.getHeader(headerName)).append(",");
        }
        sb.append("]");
        sb.append("[parameters=");
        Enumeration enparam = httpRequest.getParameterNames();
        while (enparam.hasMoreElements()) {
            String paramName = (String)enparam.nextElement();
            String[] paramValues = paramName.equals("j_password") ? new String[]{"***"} : httpRequest.getParameterValues(paramName);
            int len = paramValues != null ? paramValues.length : 0;
            for (int i = 0; i < len; ++i) {
                sb.append(paramValues[i]).append("::");
            }
            sb.append(",");
        }
        sb.append("][attributes=");
        Enumeration enu = httpRequest.getAttributeNames();
        while (enu.hasMoreElements()) {
            String attrName = (String)enu.nextElement();
            sb.append(attrName).append("=");
            sb.append(httpRequest.getAttribute(attrName)).append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

