/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms.bridge;

import org.apache.activemq.artemis.jms.bridge.JMSBridge;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeDefinition;
import org.wildfly.extension.messaging.activemq.jms.bridge.JMSBridgeService;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class JMSBridgeHandler
extends AbstractRuntimeOnlyHandler {
    public static final JMSBridgeHandler INSTANCE = new JMSBridgeHandler(false);
    public static final JMSBridgeHandler READ_ONLY_INSTANCE = new JMSBridgeHandler(true);
    private final ParametersValidator readAttributeValidator = new ParametersValidator();
    private final boolean readOnly;

    private JMSBridgeHandler(boolean readOnly) {
        this.readOnly = readOnly;
        this.readAttributeValidator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        String bridgeName = context.getCurrentAddressValue();
        final String operationName = operation.require("operation").asString();
        if (null == operationName) {
            throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
        }
        boolean modify = !"read-attribute".equals(operationName);
        ServiceName bridgeServiceName = MessagingServices.getJMSBridgeServiceName(bridgeName);
        final ServiceController bridgeService = context.getServiceRegistry(modify).getService(bridgeServiceName);
        if (bridgeService == null) {
            if (!this.readOnly) {
                throw ControllerLogger.ROOT_LOGGER.managementResourceNotFound(context.getCurrentAddress());
            }
            return;
        }
        final JMSBridge bridge = (JMSBridge)JMSBridge.class.cast(bridgeService.getValue());
        switch (operationName) {
            case "read-attribute": {
                this.readAttributeValidator.validate(operation);
                String name = operation.require("name").asString();
                if ("started".equals(name)) {
                    context.getResult().set(bridge.isStarted());
                    break;
                }
                if (CommonAttributes.PAUSED.getName().equals(name)) {
                    context.getResult().set(bridge.isPaused());
                    break;
                }
                if (CommonAttributes.MESSAGE_COUNT.getName().equals(name)) {
                    context.getResult().set(bridge.getMessageCount());
                    break;
                }
                if (JMSBridgeDefinition.ABORTED_MESSAGE_COUNT.getName().equals(name)) {
                    context.getResult().set(bridge.getAbortedMessageCount());
                    break;
                }
                throw MessagingLogger.ROOT_LOGGER.unsupportedAttribute(name);
            }
            case "start": {
                try {
                    JMSBridgeService service = (JMSBridgeService)bridgeService.getService();
                    service.startBridge();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case "stop": {
                try {
                    bridge.stop();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case "pause": {
                try {
                    bridge.pause();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case "resume": {
                try {
                    bridge.resume();
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                throw MessagingLogger.ROOT_LOGGER.unsupportedOperation(operationName);
            }
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            public void handleRollback(OperationContext context, ModelNode operation) {
                try {
                    switch (operationName) {
                        case "start": {
                            bridge.stop();
                            break;
                        }
                        case "stop": {
                            JMSBridgeService service = (JMSBridgeService)bridgeService.getService();
                            service.startBridge();
                            break;
                        }
                        case "pause": {
                            bridge.resume();
                            break;
                        }
                        case "resume": {
                            bridge.pause();
                        }
                    }
                }
                catch (Exception e) {
                    MessagingLogger.ROOT_LOGGER.revertOperationFailed(e, this.getClass().getSimpleName(), operationName, context.getCurrentAddress());
                }
            }
        });
    }
}

