/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;

public class PathsContext {
    private final Map<String, Boolean> pathsEncounteredState = new LinkedHashMap<String, Boolean>();

    public void addIncludedPath(String path) {
        this.pathsEncounteredState.put(path, Boolean.FALSE);
    }

    public boolean isIncluded(DocumentFieldPath path) {
        return this.pathsEncounteredState.keySet().contains(path.getAbsoluteName());
    }

    public void markEncounteredPath(DocumentFieldPath path) {
        this.pathsEncounteredState.put(path.getAbsoluteName(), Boolean.TRUE);
    }

    public Set<String> getEncounteredPaths() {
        return this.pathsEncounteredState.keySet();
    }

    public Set<String> getUnEncounteredPaths() {
        LinkedHashSet<String> unEncounteredPaths = new LinkedHashSet<String>();
        for (String path : this.pathsEncounteredState.keySet()) {
            if (!this.notEncountered(path)) continue;
            unEncounteredPaths.add(path);
        }
        return unEncounteredPaths;
    }

    private boolean notEncountered(String path) {
        return this.pathsEncounteredState.get(path) == false;
    }
}

