/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client.spi;

import jakarta.xml.ws.BindingProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.security.ClientConfigException;
import org.jboss.wsf.spi.security.ClientConfigProvider;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;

public class WebServicesClientConfigProviderImpl
implements ClientConfigProvider {
    private static final AuthenticationContextConfigurationClient AUTH_CONTEXT_CLIENT = AccessController.doPrivileged(AuthenticationContextConfigurationClient::new);
    private AuthenticationContext authenticationContext = AuthenticationContext.captureCurrent();

    public ClientConfig configure(ClientConfig config, BindingProvider bindingProvider) throws ClientConfigException {
        Assert.checkNotNullParam((String)"bindingProvider", (Object)bindingProvider);
        URI uri = null;
        try {
            uri = new URI(bindingProvider.getRequestContext().get("jakarta.xml.ws.service.endpoint.address").toString());
        }
        catch (URISyntaxException e) {
            throw new ClientConfigException("Unable to obtain URI");
        }
        if (this.authenticationContext == AuthenticationContext.empty()) {
            return config;
        }
        HashMap<String, Object> attachments = config == null ? new HashMap<String, Object>() : new HashMap(config.getAttachments());
        this.putNotNullProperty(attachments, "clientProviderConfigured", "true");
        this.putNotNullProperty(attachments, "clientUsername", this.getUsername(uri));
        this.putNotNullProperty(attachments, "clientPassword", this.getPassword(uri));
        this.putNotNullProperty(attachments, "clientHttpMechanism", this.getHttpMechanism(uri));
        this.putNotNullProperty(attachments, "clientWSSecurityType", this.getWsSecurityType(uri));
        attachments.put("clientSSLContext", this.getSSLContext(uri));
        if (config == null) {
            ClientConfig cc = new ClientConfig("WildFly-Client-Config", null, null, null, null);
            cc.getAttachments().putAll(attachments);
            return cc;
        }
        config.getAttachments().putAll(attachments);
        return config;
    }

    private void putNotNullProperty(Map<String, Object> props, String key, String value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    private SSLContext getSSLContext(URI uri) throws ClientConfigException {
        try {
            return AUTH_CONTEXT_CLIENT.getSSLContext(uri, this.authenticationContext);
        }
        catch (GeneralSecurityException e) {
            throw new ClientConfigException("Unable to obtain SSLContext");
        }
    }

    private String getUsername(URI uri) throws ClientConfigException {
        CallbackHandler callbackHandler = AUTH_CONTEXT_CLIENT.getCallbackHandler(AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, this.authenticationContext));
        NameCallback nameCallback = new NameCallback("user name");
        try {
            callbackHandler.handle(new Callback[]{nameCallback});
            return nameCallback.getName();
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new ClientConfigException("Name callback handling was unsuccessful");
        }
    }

    private String getPassword(URI uri) throws ClientConfigException {
        CallbackHandler callbackHandler = AUTH_CONTEXT_CLIENT.getCallbackHandler(AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, this.authenticationContext));
        PasswordCallback passwordCallback = new PasswordCallback("password", false);
        try {
            callbackHandler.handle(new Callback[]{passwordCallback});
            char[] password = passwordCallback.getPassword();
            if (password == null) {
                return null;
            }
            return new String(password);
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new ClientConfigException("Password callback handling was unsuccessful");
        }
    }

    private String getHttpMechanism(URI uri) {
        return AUTH_CONTEXT_CLIENT.getWsHttpMech(AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, this.authenticationContext));
    }

    private String getWsSecurityType(URI uri) {
        return AUTH_CONTEXT_CLIENT.getWsSecurityType(AUTH_CONTEXT_CLIENT.getAuthenticationConfiguration(uri, this.authenticationContext));
    }
}

