/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.resources;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultAddHandler;
import org.jboss.as.server.services.security.VaultRemoveHandler;
import org.jboss.as.server.services.security.VaultWriteAttributeHandler;
import org.jboss.dmr.ModelType;

public class VaultResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH = PathElement.pathElement((String)"core-service", (String)"vault");
    public static final SimpleAttributeDefinition CODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"code", (ModelType)ModelType.STRING, (boolean)true).addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES)).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.STRING, true))).setAllowExpression(true)).build();
    public static final SimpleAttributeDefinition MODULE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"module", (ModelType)ModelType.STRING, (boolean)true).addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES)).setValidator((ParameterValidator)new ModelTypeValidator(ModelType.STRING, true))).setAllowExpression(true)).setRequires(new String[]{CODE.getName()})).build();
    public static final PropertiesAttributeDefinition VAULT_OPTIONS = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("vault-options", true).addFlag(AttributeAccess.Flag.RESTART_ALL_SERVICES)).setAllowExpression(true)).setCorrector(MapAttributeDefinition.LIST_TO_MAP_CORRECTOR)).setValidator((ParameterValidator)new StringLengthValidator(1, true, true))).build();
    public static AttributeDefinition[] ALL_ATTRIBUTES = new AttributeDefinition[]{CODE, MODULE, VAULT_OPTIONS};

    public VaultResourceDefinition(AbstractVaultReader vaultReader) {
        super(new SimpleResourceDefinition.Parameters(PATH, ServerDescriptions.getResourceDescriptionResolver("vault")).setAddHandler((OperationStepHandler)new VaultAddHandler(vaultReader)).setRemoveHandler((OperationStepHandler)new VaultRemoveHandler(vaultReader)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SECURITY_VAULT}).setDeprecatedSince(ModelVersion.create((int)1, (int)7)));
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        VaultWriteAttributeHandler write = new VaultWriteAttributeHandler(ALL_ATTRIBUTES);
        for (AttributeDefinition def : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)write);
        }
    }
}

