/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.ExternalizerProvider;
import org.wildfly.clustering.marshalling.spi.ObjectExternalizer;
import org.wildfly.clustering.marshalling.spi.StringExternalizer;
import org.wildfly.clustering.marshalling.spi.ValueExternalizer;
import org.wildfly.clustering.marshalling.spi.util.BitSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.BoundedCollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.CalendarExternalizer;
import org.wildfly.clustering.marshalling.spi.util.DateExternalizer;
import org.wildfly.clustering.marshalling.spi.util.EnumMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.EnumSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.HashMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.HashSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.LinkedHashMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.MapEntryExternalizer;
import org.wildfly.clustering.marshalling.spi.util.OptionalDoubleExternalizer;
import org.wildfly.clustering.marshalling.spi.util.OptionalIntExternalizer;
import org.wildfly.clustering.marshalling.spi.util.OptionalLongExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SingletonCollectionExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SingletonMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SortedMapExternalizer;
import org.wildfly.clustering.marshalling.spi.util.SortedSetExternalizer;
import org.wildfly.clustering.marshalling.spi.util.UUIDExternalizer;
import org.wildfly.clustering.marshalling.spi.util.UnboundedCollectionExternalizer;

public enum UtilExternalizerProvider implements ExternalizerProvider
{
    ARRAY_DEQUE(new BoundedCollectionExternalizer<ArrayDeque>(ArrayDeque.class, ArrayDeque::new)),
    ARRAY_LIST(new BoundedCollectionExternalizer<ArrayList>(ArrayList.class, ArrayList::new)),
    BIT_SET(new BitSetExternalizer()),
    CALENDAR(new CalendarExternalizer()),
    CURRENCY(new StringExternalizer<Currency>(Currency.class, Currency::getInstance, Currency::getCurrencyCode)),
    DATE(new DateExternalizer<Date>(Date.class, Date::new)),
    EMPTY_ENUMERATION(new ValueExternalizer<Enumeration<T>>(Collections.emptyEnumeration())),
    EMPTY_ITERATOR(new ValueExternalizer<Iterator<T>>(Collections.emptyIterator())),
    EMPTY_LIST(new ValueExternalizer<List<T>>(Collections.emptyList())),
    EMPTY_LIST_ITERATOR(new ValueExternalizer<ListIterator<T>>(Collections.emptyListIterator())),
    EMPTY_MAP(new ValueExternalizer<Map<K, V>>(Collections.emptyMap())),
    EMPTY_NAVIGABLE_MAP(new ValueExternalizer<NavigableMap<K, V>>(Collections.emptyNavigableMap())),
    EMPTY_NAVIGABLE_SET(new ValueExternalizer<NavigableSet<E>>(Collections.emptyNavigableSet())),
    EMPTY_SET(new ValueExternalizer<Set<T>>(Collections.emptySet())),
    EMPTY_SORTED_MAP(new ValueExternalizer<SortedMap<K, V>>(Collections.emptySortedMap())),
    EMPTY_SORTED_SET(new ValueExternalizer<SortedSet<E>>(Collections.emptySortedSet())),
    ENUM_MAP(new EnumMapExternalizer<E>()),
    ENUM_SET(new EnumSetExternalizer<E>()),
    HASH_MAP(new HashMapExternalizer<HashMap>(HashMap.class, HashMap::new)),
    HASH_SET(new HashSetExternalizer<HashSet>(HashSet.class, HashSet::new)),
    LINKED_HASH_MAP(new LinkedHashMapExternalizer()),
    LINKED_HASH_SET(new HashSetExternalizer<LinkedHashSet>(LinkedHashSet.class, LinkedHashSet::new)),
    LINKED_LIST(new UnboundedCollectionExternalizer<LinkedList>(LinkedList.class, LinkedList::new)),
    LOCALE(new StringExternalizer<Locale>(Locale.class, Locale::forLanguageTag, Locale::toLanguageTag)),
    NATURAL_ORDER_COMPARATOR(new ValueExternalizer<Comparator<T>>(Comparator.naturalOrder())),
    OPTIONAL(new ObjectExternalizer<Optional>(Optional.class, Optional::ofNullable, optional -> optional.orElse(null)){

        public OptionalInt size(Optional optional) {
            return optional.isPresent() ? OptionalInt.empty() : OptionalInt.of(1);
        }
    }),
    OPTIONAL_DOUBLE(new OptionalDoubleExternalizer()),
    OPTIONAL_INT(new OptionalIntExternalizer()),
    OPTIONAL_LONG(new OptionalLongExternalizer()),
    REVERSE_ORDER_COMPARATOR(new ValueExternalizer<Comparator<T>>(Collections.reverseOrder())),
    SIMPLE_ENTRY(new MapEntryExternalizer<AbstractMap.SimpleEntry>(AbstractMap.SimpleEntry.class, AbstractMap.SimpleEntry::new)),
    SIMPLE_IMMUTABLE_ENTRY(new MapEntryExternalizer<AbstractMap.SimpleImmutableEntry>(AbstractMap.SimpleImmutableEntry.class, AbstractMap.SimpleImmutableEntry::new)),
    SINGLETON_LIST(new SingletonCollectionExternalizer<List>(Collections::singletonList)),
    SINGLETON_MAP(new SingletonMapExternalizer()),
    SINGLETON_SET(new SingletonCollectionExternalizer<Set>(Collections::singleton)),
    TIME_ZONE(new StringExternalizer<TimeZone>(TimeZone.class, TimeZone::getTimeZone, TimeZone::getID)),
    TREE_MAP(new SortedMapExternalizer<TreeMap>(TreeMap.class, TreeMap::new)),
    TREE_SET(new SortedSetExternalizer<TreeSet>(TreeSet.class, TreeSet::new)),
    UUID(new UUIDExternalizer());

    private final Externalizer<?> externalizer;

    private UtilExternalizerProvider(Externalizer<?> externalizer) {
        this.externalizer = externalizer;
    }

    @Override
    public Externalizer<?> getExternalizer() {
        return this.externalizer;
    }
}

