/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.logging.UndertowLogger;

class WebServerService
implements CommonWebServer,
Service<WebServerService> {
    private InjectedValue<Server> serverInjectedValue = new InjectedValue();

    WebServerService() {
    }

    InjectedValue<Server> getServerInjectedValue() {
        return this.serverInjectedValue;
    }

    public int getPort(String protocol, boolean secure) {
        Map<String, UndertowListener> listeners = this.getListenerMap();
        UndertowListener listener = null;
        for (String p : listeners.keySet()) {
            if (!protocol.toLowerCase().contains(p)) continue;
            listener = listeners.get(p);
        }
        if (listener != null && listener.getProtocol() == "http" && secure) {
            if (listeners.containsKey("https")) {
                listener = listeners.get("https");
            } else {
                UndertowLogger.ROOT_LOGGER.secureListenerNotAvailableForPort(protocol);
            }
        }
        if (listener != null) {
            SocketBinding binding = listener.getSocketBinding();
            return binding.getAbsolutePort();
        }
        throw UndertowLogger.ROOT_LOGGER.noPortListeningForProtocol(protocol);
    }

    private Map<String, UndertowListener> getListenerMap() {
        HashMap<String, UndertowListener> listeners = new HashMap<String, UndertowListener>();
        for (UndertowListener listener : ((Server)this.serverInjectedValue.getValue()).getListeners()) {
            listeners.put(listener.getProtocol(), listener);
        }
        return listeners;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public WebServerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

