/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.transformer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.wildfly.extras.transformer.ArchiveTransformer;
import org.wildfly.extras.transformer.TransformerBuilder;
import org.wildfly.extras.transformer.TransformerFactory;
import org.wildfly.galleon.plugin.transformer.JakartaTransformer;
import org.wildfly.galleon.plugin.transformer.JarUtils;
import org.wildfly.galleon.plugin.transformer.TransformedArtifact;

public class BataviaTransformer {
    static TransformedArtifact transform(Path configsDir, Path src, Path target, boolean verbose, JakartaTransformer.LogHandler log) throws IOException {
        boolean transformed;
        boolean signed = false;
        boolean unsigned = false;
        try {
            transformed = BataviaTransformer.transform(configsDir != null ? configsDir.toString() : null, src.toString(), target.toString(), verbose);
            if (src.getFileName().toString().endsWith(".jar")) {
                signed = JarUtils.isSignedJar(src);
            }
            if (transformed) {
                log.print("EE9: transformed %s", target.getFileName().toString());
            }
            if (signed && transformed) {
                log.print("WARNING: EE9: unsigning transformed %s ", target.getFileName().toString());
                JarUtils.unsign(target);
                unsigned = true;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return new TransformedArtifact(src, target, transformed, signed, unsigned);
    }

    static boolean transform(String configsDir, String source, String target, boolean verbose) throws Exception {
        TransformerBuilder builder = TransformerFactory.getInstance().newTransformer();
        builder.setVerbose(verbose);
        if (configsDir != null) {
            builder.setConfigsDir(configsDir);
        }
        ArchiveTransformer transformer = builder.build();
        return transformer.transform(new File(source), new File(target));
    }
}

