/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Runner;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

@Experimental
@MBean(description="Simple TCP based transport")
public class SimpleTCP
extends TP {
    @Property(description="size in bytes of TCP receiver window")
    protected int recv_buf_size = 500000;
    @Property(description="size in bytes of TCP send window")
    protected int send_buf_size = 500000;
    @Property(description="Size of the buffer of the BufferedInputStream in TcpConnection. A read always tries to read ahead as much data as possible into the buffer. 0: default size")
    protected int buffered_input_stream_size = 8192;
    @Property(description="Size of the buffer of the BufferedOutputStream in TcpConnection. Smaller messages are  buffered until this size is exceeded or flush() is called. Bigger messages are sent immediately. 0: default size")
    protected int buffered_output_stream_size = 8192;
    protected ServerSocket srv_sock;
    protected Acceptor acceptor;
    protected final Map<SocketAddress, Connection> connections = new ConcurrentHashMap<SocketAddress, Connection>();
    protected final Map<Address, SocketAddress> addr_table = new ConcurrentHashMap<Address, SocketAddress>();

    @Override
    public boolean supportsMulticasting() {
        return false;
    }

    @ManagedOperation(description="dumps the address table")
    public String printAddressTable() {
        return this.addr_table.entrySet().stream().collect(StringBuilder::new, (sb, e) -> sb.append(e.getKey()).append(": ").append(e.getValue()).append("\n"), (l, r) -> {}).toString();
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
    }

    @Override
    public String getInfo() {
        return "SimpleTCP";
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.srv_sock = Util.createServerSocket(new DefaultSocketFactory(), "srv-sock", this.bind_addr, this.bind_port, this.bind_port + 50);
        this.acceptor = new Acceptor(this.bind_addr, this.bind_port);
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.acceptor.start();
    }

    @Override
    public void stop() {
        super.stop();
        Util.close((Closeable)this.srv_sock);
        this.acceptor.stop();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.acceptor.stop();
        this.connections.values().forEach(Util::close);
        this.connections.clear();
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.type()) {
            case 89: {
                Tuple tuple = (Tuple)evt.arg();
                IpAddress val = (IpAddress)tuple.getVal2();
                this.addr_table.put((Address)tuple.getVal1(), new InetSocketAddress(val.getIpAddress(), val.getPort()));
                break;
            }
            case 6: {
                Iterator<Map.Entry<Address, SocketAddress>> it = this.addr_table.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Address, SocketAddress> entry = it.next();
                    if (this.view.containsMember(entry.getKey())) continue;
                    SocketAddress sock_addr = entry.getValue();
                    it.remove();
                    Connection conn = this.connections.remove(sock_addr);
                    Util.close((Closeable)conn);
                }
                break;
            }
        }
        return retval;
    }

    @Override
    public Object down(Message msg) {
        try {
            return this._down(msg);
        }
        catch (Exception e) {
            this.log.error("failure passing message down", e);
            return null;
        }
    }

    protected Object _down(Message msg) throws Exception {
        Address dest = msg.dest();
        this.setSourceAddress(msg);
        int size = (int)msg.size();
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(size + 4);
        out.writeInt(size);
        msg.writeTo(out);
        if (dest != null) {
            this.sendTo(dest, out.buffer(), 0, out.position());
        } else {
            Collection<Address> dests = this.view != null ? this.view.getMembers() : this.addr_table.keySet();
            for (Address dst : dests) {
                try {
                    this.sendTo(dst, out.buffer(), 0, out.position());
                }
                catch (Throwable t) {
                    this.log.error("failed sending multicast message to " + dst, t);
                }
            }
        }
        return null;
    }

    protected void sendTo(Address dest, byte[] buffer, int offset, int length) throws Exception {
        SocketAddress physical_dest = null;
        if (dest instanceof IpAddress) {
            IpAddress ip_addr = (IpAddress)dest;
            physical_dest = new InetSocketAddress(ip_addr.getIpAddress(), ip_addr.getPort());
        } else {
            physical_dest = this.addr_table.get(dest);
        }
        if (physical_dest == null) {
            throw new Exception(String.format("physical address for %s not found", dest));
        }
        Connection conn = this.getConnection(physical_dest);
        conn.send(buffer, offset, length);
    }

    protected Connection getConnection(SocketAddress dest) throws Exception {
        Connection conn = this.connections.get(dest);
        if (conn != null) {
            return conn;
        }
        Socket dest_sock = new Socket();
        if (this.send_buf_size > 0) {
            dest_sock.setSendBufferSize(this.send_buf_size);
        }
        if (this.recv_buf_size > 0) {
            dest_sock.setReceiveBufferSize(this.recv_buf_size);
        }
        dest_sock.connect(dest);
        conn = new Connection(dest_sock).start();
        Connection c = this.connections.putIfAbsent(dest, conn);
        if (c != null) {
            Util.close((Closeable)conn);
            return c;
        }
        return conn;
    }

    @Override
    protected boolean addPhysicalAddressToCache(Address logical_addr, PhysicalAddress physical_addr) {
        IpAddress tmp = (IpAddress)physical_addr;
        this.addr_table.put(logical_addr, new InetSocketAddress(tmp.getIpAddress(), tmp.getPort()));
        return super.addPhysicalAddressToCache(logical_addr, physical_addr);
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return new IpAddress((InetSocketAddress)this.srv_sock.getLocalSocketAddress());
    }

    protected class Connection
    implements Runnable,
    Closeable {
        protected final Socket sock;
        protected final IpAddress peer_addr;
        protected final DataInputStream in;
        protected final DataOutputStream out;
        protected final Runner runner;
        protected byte[] buffer = new byte[1024];
        protected final AtomicInteger writers = new AtomicInteger(0);

        public Connection(Socket sock) throws Exception {
            this.sock = sock;
            this.peer_addr = new IpAddress((InetSocketAddress)sock.getRemoteSocketAddress());
            this.in = new DataInputStream(this.createBufferedInputStream(sock.getInputStream()));
            this.out = new DataOutputStream(this.createBufferedOutputStream(sock.getOutputStream()));
            this.runner = new Runner(new DefaultThreadFactory("tcp", false, true), "conn-" + sock.getLocalPort(), this, null);
        }

        protected Connection start() {
            this.runner.start();
            return this;
        }

        @Override
        public void close() {
            this.runner.stop();
            Util.close(this.in, this.out, this.sock);
        }

        protected void send(byte[] buffer, int offset, int length) throws Exception {
            this.writers.incrementAndGet();
            this.out.write(buffer, offset, length);
            if (this.writers.decrementAndGet() == 0) {
                this.out.flush();
            }
        }

        @Override
        public void run() {
            try {
                int len = this.in.readInt();
                if (this.buffer == null || this.buffer.length < len) {
                    this.buffer = new byte[len];
                }
                this.in.readFully(this.buffer, 0, len);
                ByteArrayDataInputStream input = new ByteArrayDataInputStream(this.buffer, 0, len);
                Message msg = new Message(false);
                msg.readFrom(input);
                SimpleTCP.this.thread_pool.execute(() -> SimpleTCP.this.up_prot.up(msg));
            }
            catch (IOException io_ex) {
                this.runner.stop();
                throw new RuntimeException(io_ex);
            }
            catch (Exception ex) {
                if (this.sock.isClosed()) {
                    this.runner.stop();
                }
                throw new RuntimeException(ex);
            }
        }

        public String toString() {
            return String.format("%s -> %s", this.sock.getLocalSocketAddress(), this.peer_addr);
        }

        protected BufferedOutputStream createBufferedOutputStream(OutputStream out) {
            int size = SimpleTCP.this.buffered_output_stream_size;
            return size == 0 ? new BufferedOutputStream(out) : new BufferedOutputStream(out, size);
        }

        protected BufferedInputStream createBufferedInputStream(InputStream in) {
            int size = SimpleTCP.this.buffered_input_stream_size;
            return size == 0 ? new BufferedInputStream(in) : new BufferedInputStream(in, size);
        }
    }

    protected class Acceptor
    implements Runnable {
        protected final InetAddress bind;
        protected final int port;
        protected Runner runner;

        public Acceptor(InetAddress bind, int port) throws Exception {
            this.bind = bind;
            this.port = port;
            this.runner = new Runner(new DefaultThreadFactory("tcp", true, true), "acceptor", this, null);
        }

        protected void start() throws Exception {
            this.runner.start();
        }

        protected void stop() {
            this.runner.stop();
        }

        @Override
        public void run() {
            try {
                Socket client_sock = SimpleTCP.this.srv_sock.accept();
                if (SimpleTCP.this.send_buf_size > 0) {
                    client_sock.setSendBufferSize(SimpleTCP.this.send_buf_size);
                }
                if (SimpleTCP.this.recv_buf_size > 0) {
                    client_sock.setReceiveBufferSize(SimpleTCP.this.recv_buf_size);
                }
                Connection c = new Connection(client_sock).start();
                Connection existing = SimpleTCP.this.connections.putIfAbsent(client_sock.getRemoteSocketAddress(), c);
                if (existing != null) {
                    Util.close((Closeable)c);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

