/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wst11.ba.remote;

import com.arjuna.mw.wsc11.context.Context;
import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst11.UserBusinessActivity;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.mwlabs.wst.ba.remote.ContextManager;
import com.arjuna.mwlabs.wst11.ba.ContextImple;
import com.arjuna.mwlabs.wst11.ba.context.TxContextImple;
import com.arjuna.mwlabs.wst11.ba.remote.UserSubordinateBusinessActivityImple;
import com.arjuna.webservices.SoapFault;
import com.arjuna.webservices11.ServiceRegistry;
import com.arjuna.webservices11.util.PrivilegedServiceRegistryFactory;
import com.arjuna.webservices11.wsarj.InstanceIdentifier;
import com.arjuna.webservices11.wsarjtx.ArjunaTX11Constants;
import com.arjuna.wsc.InvalidCreateParametersException;
import com.arjuna.wsc11.ActivationCoordinator;
import com.arjuna.wsc11.RegistrationCoordinator;
import com.arjuna.wsc11.messaging.MessageId;
import com.arjuna.wst.SystemException;
import com.arjuna.wst.TransactionRolledBackException;
import com.arjuna.wst.UnknownTransactionException;
import com.arjuna.wst.WrongStateException;
import com.arjuna.wst11.stub.BusinessActivityTerminatorStub;
import jakarta.xml.ws.wsaddressing.W3CEndpointReference;
import jakarta.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import javax.xml.namespace.QName;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContext;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;

public class UserBusinessActivityImple
extends UserBusinessActivity {
    private ContextManager _ctxManager = new ContextManager();
    private String _activationCoordinatorService;
    private UserSubordinateBusinessActivityImple _userSubordinateBusinessActivity;

    public UserBusinessActivityImple() {
        try {
            this._activationCoordinatorService = XTSPropertyManager.getWSCEnvironmentBean().getCoordinatorURL11();
            if (this._activationCoordinatorService == null) {
                ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
                this._activationCoordinatorService = serviceRegistry.getServiceURI("ActivationService");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this._userSubordinateBusinessActivity = new UserSubordinateBusinessActivityImple();
    }

    @Override
    public UserBusinessActivity getUserSubordinateBusinessActivity() {
        return this._userSubordinateBusinessActivity;
    }

    @Override
    public void begin() throws WrongStateException, SystemException {
        this.begin(0);
    }

    @Override
    public void begin(int timeout) throws WrongStateException, SystemException {
        try {
            if (this._ctxManager.currentTransaction() != null) {
                throw new WrongStateException();
            }
            Context ctx = this.startTransaction(timeout, null);
            this._ctxManager.resume(new TxContextImple(ctx));
        }
        catch (InvalidCreateParametersException ex) {
            this.tidyup();
            throw new SystemException(ex.toString());
        }
        catch (UnknownTransactionException ex) {
            this.tidyup();
            throw new SystemException(ex.toString());
        }
        catch (SystemException ex) {
            this.tidyup();
            throw ex;
        }
    }

    @Override
    public void close() throws TransactionRolledBackException, UnknownTransactionException, SystemException, WrongStateException {
        TxContextImple ctx = null;
        try {
            ctx = (TxContextImple)this._ctxManager.suspend();
            if (ctx == null) {
                throw new WrongStateException();
            }
            String id = ctx.identifier();
            W3CEndpointReference terminatorCoordinator = this.getTerminationCoordinator(ctx);
            BusinessActivityTerminatorStub terminatorStub = new BusinessActivityTerminatorStub(id, terminatorCoordinator);
            terminatorStub.close();
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (TransactionRolledBackException ex) {
            throw ex;
        }
        catch (WrongStateException ex) {
            throw ex;
        }
        catch (UnknownTransactionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SystemException(ex.toString());
        }
        finally {
            this.tidyup();
        }
    }

    @Override
    public void cancel() throws UnknownTransactionException, SystemException, WrongStateException {
        TxContextImple ctx = null;
        try {
            ctx = (TxContextImple)this._ctxManager.suspend();
            if (ctx == null) {
                throw new WrongStateException();
            }
            String id = ctx.identifier();
            W3CEndpointReference terminatorCoordinator = this.getTerminationCoordinator(ctx);
            BusinessActivityTerminatorStub terminatorStub = new BusinessActivityTerminatorStub(id, terminatorCoordinator);
            terminatorStub.cancel();
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (WrongStateException ex) {
            throw ex;
        }
        catch (UnknownTransactionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SystemException(ex.toString());
        }
        finally {
            this.tidyup();
        }
    }

    @Override
    public void complete() throws UnknownTransactionException, SystemException, WrongStateException {
        try {
            TxContextImple ctx = (TxContextImple)this._ctxManager.currentTransaction();
            if (ctx == null) {
                throw new WrongStateException();
            }
            String id = ctx.identifier();
            W3CEndpointReference terminatorCoordinator = this.getTerminationCoordinator(ctx);
            BusinessActivityTerminatorStub terminatorStub = new BusinessActivityTerminatorStub(id, terminatorCoordinator);
            terminatorStub.complete();
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (UnknownTransactionException ex) {
            throw ex;
        }
        catch (WrongStateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    @Override
    public String transactionIdentifier() {
        try {
            return this._ctxManager.currentTransaction().toString();
        }
        catch (SystemException ex) {
            return "Unknown";
        }
        catch (NullPointerException ex) {
            return "Unknown";
        }
    }

    public String toString() {
        return this.transactionIdentifier();
    }

    public void beginSubordinate(int timeout) throws WrongStateException, SystemException {
        try {
            TxContext current = this._ctxManager.currentTransaction();
            if (current == null || !(current instanceof TxContextImple)) {
                throw new WrongStateException();
            }
            TxContextImple currentImple = (TxContextImple)current;
            Context ctx = this.startTransaction(timeout, currentImple);
            this._ctxManager.resume(new TxContextImple(ctx));
        }
        catch (InvalidCreateParametersException ex) {
            this.tidyup();
            throw new SystemException(ex.toString());
        }
        catch (UnknownTransactionException ex) {
            this.tidyup();
            throw new SystemException(ex.toString());
        }
        catch (SystemException ex) {
            this.tidyup();
            throw ex;
        }
    }

    private CoordinationContext getContext(TxContextImple current) {
        CoordinationContextType contextType = this.getContextType(current);
        CoordinationContext context = new CoordinationContext();
        context.setCoordinationType(contextType.getCoordinationType());
        context.setExpires(contextType.getExpires());
        context.setIdentifier(contextType.getIdentifier());
        context.setRegistrationService(contextType.getRegistrationService());
        return context;
    }

    private CoordinationContextType getContextType(TxContextImple current) {
        ContextImple contextImple = (ContextImple)current.context();
        return contextImple.getCoordinationContext();
    }

    private final Context startTransaction(int timeout, TxContextImple current) throws InvalidCreateParametersException, SystemException {
        try {
            Long expires = timeout > 0 ? new Long(timeout) : null;
            String messageId = MessageId.getMessageId();
            CoordinationContext currentContext = current != null ? this.getContext(current) : null;
            CoordinationContextType coordinationContext = ActivationCoordinator.createCoordinationContext(this._activationCoordinatorService, messageId, "http://docs.oasis-open.org/ws-tx/wsba/2006/06/AtomicOutcome", expires, currentContext);
            if (coordinationContext == null) {
                throw new SystemException(wstxLogger.i18NLogger.get_mwlabs_wst11_ba_remote_UserBusinessActivityImple_2());
            }
            return new ContextImple(coordinationContext);
        }
        catch (InvalidCreateParametersException icpe) {
            throw icpe;
        }
        catch (SoapFault sf) {
            throw new SystemException(sf.getMessage());
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    private W3CEndpointReference getTerminationCoordinator(TxContextImple ctx) throws SystemException {
        CoordinationContextType coordinationContext = ctx.context().getCoordinationContext();
        String messageId = MessageId.getMessageId();
        try {
            return RegistrationCoordinator.register(coordinationContext, messageId, this.getParticipantProtocolService(ctx.identifier(), ctx.isSecure()), "http://schemas.arjuna.com/ws/2005/10/wsarjtx/BATermination");
        }
        catch (Throwable th) {
            throw new SystemException(wstxLogger.i18NLogger.get_mwlabs_wst11_ba_remote_UserBusinessActivityImple_3());
        }
    }

    private W3CEndpointReference getParticipantProtocolService(String id, boolean isSecure) {
        QName serviceId = ArjunaTX11Constants.TERMINATION_PARTICIPANT_SERVICE_QNAME;
        QName endpointId = ArjunaTX11Constants.TERMINATION_PARTICIPANT_PORT_QNAME;
        ServiceRegistry serviceRegistry = PrivilegedServiceRegistryFactory.getInstance().getServiceRegistry();
        String address = serviceRegistry.getServiceURI("TerminationParticipantService", isSecure);
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.serviceName(serviceId);
        builder.endpointName(endpointId);
        builder.address(address);
        InstanceIdentifier.setEndpointInstanceIdentifier(builder, id);
        return builder.build();
    }

    private final void tidyup() {
        try {
            this._ctxManager.suspend();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

