/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.baggage;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.api.baggage.ImmutableEntry;
import io.opentelemetry.api.internal.ImmutableKeyValuePairs;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.context.Context;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
final class ImmutableBaggage
extends ImmutableKeyValuePairs<String, BaggageEntry>
implements Baggage {
    private static final Baggage EMPTY = new Builder().build();

    ImmutableBaggage(List<Object> data) {
        super(data);
    }

    static Baggage empty() {
        return EMPTY;
    }

    static BaggageBuilder builder() {
        return new Builder();
    }

    @Override
    @Nullable
    public String getEntryValue(String entryKey) {
        BaggageEntry entry = (BaggageEntry)this.get(entryKey);
        return entry != null ? entry.getValue() : null;
    }

    @Override
    public BaggageBuilder toBuilder() {
        Builder builder = new Builder(new ArrayList<Object>(this.data()));
        builder.noImplicitParent = true;
        return builder;
    }

    private static Baggage sortAndFilterToBaggage(Object[] data) {
        return new ImmutableBaggage(ImmutableBaggage.sortAndFilter(data));
    }

    private static boolean isKeyValid(String name) {
        return name != null && !name.isEmpty() && StringUtils.isPrintableString(name);
    }

    private static boolean isValueValid(String value) {
        return value != null && StringUtils.isPrintableString(value);
    }

    static class Builder
    implements BaggageBuilder {
        @Nullable
        private Baggage parent;
        private boolean noImplicitParent;
        private final List<Object> data;

        Builder() {
            this.data = new ArrayList<Object>();
        }

        Builder(List<Object> data) {
            this.data = new ArrayList<Object>(data);
        }

        @Override
        public BaggageBuilder setParent(Context context) {
            Objects.requireNonNull(context, "context");
            this.parent = Baggage.fromContext(context);
            return this;
        }

        @Override
        public BaggageBuilder setNoParent() {
            this.parent = null;
            this.noImplicitParent = true;
            return this;
        }

        @Override
        public BaggageBuilder put(String key, String value, BaggageEntryMetadata entryMetadata) {
            if (!ImmutableBaggage.isKeyValid(key) || !ImmutableBaggage.isValueValid(value) || entryMetadata == null) {
                return this;
            }
            this.data.add(key);
            this.data.add(ImmutableEntry.create(value, entryMetadata));
            return this;
        }

        @Override
        public BaggageBuilder remove(String key) {
            if (key == null) {
                return this;
            }
            this.data.add(key);
            this.data.add(null);
            return this;
        }

        @Override
        public Baggage build() {
            if (this.parent == null && !this.noImplicitParent) {
                this.parent = Baggage.current();
            }
            List<Object> data = this.data;
            if (this.parent != null && !this.parent.isEmpty()) {
                ArrayList<Object> merged = new ArrayList<Object>(this.parent.size() * 2 + data.size());
                if (this.parent instanceof ImmutableBaggage) {
                    merged.addAll(((ImmutableBaggage)this.parent).data());
                } else {
                    this.parent.forEach((key, entry) -> {
                        merged.add(key);
                        merged.add(entry);
                    });
                }
                merged.addAll(data);
                data = merged;
            }
            return ImmutableBaggage.sortAndFilterToBaggage(data.toArray());
        }
    }
}

