/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedCallable;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.serialization.ConstructorHolder;
import org.jboss.weld.util.reflection.Formats;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SUITABLE_CONSTRUCTOR", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class BackedAnnotatedConstructor<X>
extends BackedAnnotatedCallable<X, Constructor<X>>
implements AnnotatedConstructor<X>,
Serializable {
    public static <X> AnnotatedConstructor<X> of(Constructor<X> constructor, BackedAnnotatedType<X> declaringType, SharedObjectCache sharedObjectCache) {
        return new BackedAnnotatedConstructor<X>(constructor, declaringType, sharedObjectCache);
    }

    public BackedAnnotatedConstructor(Constructor<X> constructor, BackedAnnotatedType<X> declaringType, SharedObjectCache sharedObjectCache) {
        super(constructor, constructor.getDeclaringClass(), declaringType, sharedObjectCache);
    }

    @Override
    protected List<AnnotatedParameter<X>> initParameters(Constructor<X> member, SharedObjectCache sharedObjectCache) {
        int length = member.getParameterTypes().length;
        if (length == member.getGenericParameterTypes().length && length == member.getParameterAnnotations().length) {
            return BackedAnnotatedParameter.forExecutable(member, this, sharedObjectCache);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return Formats.formatAnnotatedConstructor(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.serializationProxyRequired();
    }

    private static class SerializationProxy<X>
    extends BackedAnnotatedMember.BackedAnnotatedMemberSerializationProxy<X, AnnotatedConstructor<X>> {
        private static final long serialVersionUID = -2726172060851333254L;

        public SerializationProxy(BackedAnnotatedConstructor<X> constructor) {
            super(constructor.getDeclaringType(), new ConstructorHolder((Constructor)constructor.getJavaMember()));
        }

        private Object readResolve() throws ObjectStreamException {
            return this.resolve();
        }

        @Override
        protected Iterable<AnnotatedConstructor<X>> getCandidates() {
            return this.type.getConstructors();
        }
    }
}

