/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.check;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.activemq.artemis.cli.commands.check.CheckAbstract;
import org.apache.activemq.artemis.cli.commands.check.CheckContext;
import org.apache.activemq.artemis.cli.commands.check.CheckException;
import org.apache.activemq.artemis.cli.commands.check.CheckTask;

@Command(name="queue", description="Check a queue")
public class QueueCheck
extends CheckAbstract {
    @Option(name={"--up"}, description="Check that the queue exists and is not paused, it is executed by default if there are no other checks")
    private boolean up;
    @Option(name={"--browse"}, description="Number of the messages to browse or -1 to check that the queue is browsable")
    private Integer browse;
    @Option(name={"--consume"}, description="Number of the messages to consume or -1 to check that the queue is consumable")
    private Integer consume;
    @Option(name={"--produce"}, description="Number of the messages to produce")
    private Integer produce;

    public boolean isUp() {
        return this.up;
    }

    public void setUp(boolean up) {
        this.up = up;
    }

    public Integer getBrowse() {
        return this.browse;
    }

    public void setBrowse(Integer browse) {
        this.browse = browse;
    }

    public Integer getConsume() {
        return this.consume;
    }

    public void setConsume(Integer consume) {
        this.consume = consume;
    }

    public Integer getProduce() {
        return this.produce;
    }

    public void setProduce(Integer produce) {
        this.produce = produce;
    }

    @Override
    protected CheckTask[] getCheckTasks() {
        ArrayList<CheckTask> checkTasks = new ArrayList<CheckTask>();
        if (this.getName() == null) {
            this.name = this.input("--name", "Name is a mandatory property for Queue check", null);
        }
        if (this.getName() == null) {
            throw new IllegalArgumentException("The name of the queue is required");
        }
        if (this.produce != null) {
            if (this.produce > 0) {
                checkTasks.add(new CheckTask(String.format("a producer can send %d messages to the queue %s", this.produce, this.getName()), this::checkQueueProduce));
            } else {
                throw new IllegalArgumentException("Invalid  number of messages to produce: " + this.produce);
            }
        }
        if (this.browse != null) {
            if (this.browse == -1) {
                checkTasks.add(new CheckTask(String.format("a consumer can browse the queue %s", this.getName()), this::checkQueueBrowse));
            } else if (this.browse > 0) {
                checkTasks.add(new CheckTask(String.format("a consumer can browse %d messages from the queue %s", this.browse, this.getName()), this::checkQueueBrowse));
            } else {
                throw new IllegalArgumentException("Invalid  number of messages to browse: " + this.browse);
            }
        }
        if (this.consume != null) {
            if (this.consume == -1) {
                checkTasks.add(new CheckTask(String.format("a consumer can consume the queue %s", this.getName()), this::checkQueueConsume));
            } else if (this.consume > 0) {
                checkTasks.add(new CheckTask(String.format("a consumer can consume %d messages from the queue %s", this.consume, this.getName()), this::checkQueueConsume));
            } else {
                throw new IllegalArgumentException("Invalid  number of messages to consume: " + this.consume);
            }
        }
        if (this.up || checkTasks.size() == 0) {
            checkTasks.add(0, new CheckTask(String.format("the queue %s exists and is not paused", this.getName()), this::checkQueueUp));
        }
        return checkTasks.toArray(new CheckTask[checkTasks.size()]);
    }

    private void checkQueueUp(CheckContext context) throws Exception {
        if (((Boolean)context.getManagementProxy().invokeOperation(Boolean.class, "queue." + this.getName(), "isPaused", new Object[0])).booleanValue()) {
            throw new CheckException("The queue is paused.");
        }
    }

    private void checkQueueProduce(CheckContext context) throws Exception {
        try (Connection connection = context.getFactory().createConnection();
             Session session = connection.createSession(false, 1);
             MessageProducer queueProducer = session.createProducer((Destination)session.createQueue(this.getName()));){
            connection.start();
            for (int count = 0; count < this.produce; ++count) {
                queueProducer.send((Message)session.createTextMessage("CHECK_MESSAGE"));
            }
        }
    }

    private void checkQueueBrowse(CheckContext context) throws Exception {
        try (Connection connection = context.getFactory().createConnection();
             Session session = connection.createSession(false, 1);
             QueueBrowser queueBrowser = session.createBrowser(session.createQueue(this.getName()));){
            connection.start();
            Enumeration queueBrowserEnum = queueBrowser.getEnumeration();
            if (this.browse == -1) {
                queueBrowserEnum.hasMoreElements();
            } else {
                for (int count = 0; count < this.browse; ++count) {
                    if (queueBrowserEnum.hasMoreElements() && queueBrowserEnum.nextElement() != null) continue;
                    throw new CheckException("Insufficient messages to browse: " + count);
                }
            }
        }
    }

    private void checkQueueConsume(CheckContext context) throws Exception {
        try (Connection connection = context.getFactory().createConnection();
             Session session = connection.createSession(false, 1);
             MessageConsumer queueConsumer = session.createConsumer((Destination)session.createQueue(this.getName()));){
            connection.start();
            if (this.consume == -1) {
                queueConsumer.receiveNoWait();
            } else {
                for (int count = 0; count < this.consume; ++count) {
                    if (queueConsumer.receive() != null) continue;
                    throw new CheckException("Insufficient messages to consume: " + count);
                }
            }
        }
    }
}

