/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server.servlet;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.wildfly.elytron.web.undertow.server.servlet.CleanUpTask;

class CleanUpHandler
implements HttpHandler {
    private final HttpHandler next;

    CleanUpHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        try {
            this.next.handleRequest(exchange);
        }
        finally {
            CleanUpTask cleanUpTask = (CleanUpTask)exchange.getAttachment(CleanUpTask.ATTACHMENT_KEY);
            if (cleanUpTask != null) {
                cleanUpTask.cleanUp(exchange);
            }
        }
    }
}

