/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.TagsUtils;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.exporters.ExporterUtil;
import io.smallrye.metrics.exporters.JsonProviderHolder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

public class JsonExporter
implements Exporter {
    private Map<String, String> globalTags;
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true);

    public JsonExporter() {
        try {
            Config config = ConfigProvider.getConfig();
            this.globalTags = TagsUtils.parseGlobalTags(config.getOptionalValue("mp.metrics.tags", String.class).orElse(""));
        }
        catch (ExceptionInInitializerError | IllegalStateException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    @Override
    public StringBuilder exportOneScope(MetricRegistry.Type scope) {
        return this.stringify(this.exportOneRegistry(MetricRegistries.get(scope)));
    }

    @Override
    public StringBuilder exportAllScopes() {
        JsonObjectBuilder root = JsonProviderHolder.get().createObjectBuilder();
        root.add("base", (JsonValue)this.exportOneRegistry(MetricRegistries.get(MetricRegistry.Type.BASE)));
        root.add("vendor", (JsonValue)this.exportOneRegistry(MetricRegistries.get(MetricRegistry.Type.VENDOR)));
        root.add("application", (JsonValue)this.exportOneRegistry(MetricRegistries.get(MetricRegistry.Type.APPLICATION)));
        return this.stringify(root.build());
    }

    @Override
    public StringBuilder exportOneMetric(MetricRegistry.Type scope, MetricID metricID) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map metricMap = registry.getMetrics();
        Map metadataMap = registry.getMetadata();
        Metric m = (Metric)metricMap.get(metricID);
        HashMap<MetricID, Metric> outMap = new HashMap<MetricID, Metric>(1);
        outMap.put(metricID, m);
        JsonObjectBuilder root = JsonProviderHolder.get().createObjectBuilder();
        this.exportMetricsForMap(outMap, metadataMap).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        return this.stringify(root.build());
    }

    @Override
    public StringBuilder exportMetricsByName(MetricRegistry.Type scope, String name) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map<MetricID, Metric> metricMap = registry.getMetrics().entrySet().stream().filter(e -> ((MetricID)e.getKey()).getName().equals(name)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map metadataMap = registry.getMetadata();
        JsonObjectBuilder root = JsonProviderHolder.get().createObjectBuilder();
        this.exportMetricsForMap(metricMap, metadataMap).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        return this.stringify(root.build());
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    StringBuilder stringify(JsonObject obj) {
        StringWriter out = new StringWriter();
        try (JsonWriter writer = JsonProviderHolder.get().createWriterFactory(JSON_CONFIG).createWriter((Writer)out);){
            writer.writeObject(obj);
        }
        return new StringBuilder(out.toString());
    }

    private Map<String, JsonValue> exportMetricsByName(Map<MetricID, Metric> metricMap, Metadata metadata) {
        HashMap<String, JsonValue> result = new HashMap<String, JsonValue>();
        JsonObjectBuilder builder = JsonProviderHolder.get().createObjectBuilder();
        switch (metadata.getTypeRaw()) {
            case GAUGE: 
            case COUNTER: {
                metricMap.forEach((metricID, metric) -> result.put(metricID.getName() + this.createTagsString(metricID.getTags()), this.exportSimpleMetric((MetricID)metricID, (Metric)metric)));
                break;
            }
            case METERED: {
                metricMap.forEach((metricID, value) -> {
                    Metered metric = (Metered)value;
                    this.meterValues(metric, this.createTagsString(metricID.getTags())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            case CONCURRENT_GAUGE: {
                metricMap.forEach((metricID, value) -> {
                    ConcurrentGauge metric = (ConcurrentGauge)value;
                    this.exportConcurrentGauge(metric, this.createTagsString(metricID.getTags())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            case SIMPLE_TIMER: {
                metricMap.forEach((metricID, value) -> {
                    SimpleTimer metric = (SimpleTimer)value;
                    this.exportSimpleTimer(metric, metadata.getUnit(), this.createTagsString(metricID.getTags())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            case TIMER: {
                metricMap.forEach((metricID, value) -> {
                    Timer metric = (Timer)value;
                    this.exportTimer(metric, metadata.getUnit(), this.createTagsString(metricID.getTags())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            case HISTOGRAM: {
                metricMap.forEach((metricID, value) -> {
                    Histogram metric = (Histogram)value;
                    this.exportHistogram(metric, this.createTagsString(metricID.getTags())).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
                });
                result.put(metadata.getName(), (JsonValue)builder.build());
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported: " + metadata.getTypeRaw());
            }
        }
        return result;
    }

    private JsonObject exportOneRegistry(MetricRegistry registry) {
        Map metricMap = registry.getMetrics();
        Map metadataMap = registry.getMetadata();
        JsonObjectBuilder root = JsonProviderHolder.get().createObjectBuilder();
        this.exportMetricsForMap(metricMap, metadataMap).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)root).add(arg_0, arg_1));
        return root.build();
    }

    private Map<String, JsonValue> exportMetricsForMap(Map<MetricID, Metric> metricMap, Map<String, Metadata> metadataMap) {
        HashMap<String, JsonValue> result = new HashMap<String, JsonValue>();
        Map<String, Map<MetricID, Metric>> metricsGroupedByName = metricMap.entrySet().stream().collect(Collectors.groupingBy(entry -> ((MetricID)entry.getKey()).getName(), Collectors.mapping(e -> e, Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        metricsGroupedByName.entrySet().stream().map(entry -> this.exportMetricsByName((Map)entry.getValue(), (Metadata)metadataMap.get(entry.getKey()))).forEach(map -> map.forEach(result::put));
        return result;
    }

    private JsonValue exportSimpleMetric(MetricID metricID, Metric metric) {
        Number val = this.getValueFromMetric(metric, metricID.getName());
        if (val instanceof Double) {
            return JsonProviderHolder.get().createValue(((Double)val).doubleValue());
        }
        if (val instanceof Float) {
            return JsonProviderHolder.get().createValue((double)((Float)val).floatValue());
        }
        if (val instanceof Integer) {
            return JsonProviderHolder.get().createValue(((Integer)val).intValue());
        }
        if (val instanceof Long) {
            return JsonProviderHolder.get().createValue(((Long)val).longValue());
        }
        throw new IllegalStateException();
    }

    private Map<String, JsonValue> meterValues(Metered meter, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("count" + tags, (JsonValue)JsonProviderHolder.get().createValue(meter.getCount()));
        map.put("meanRate" + tags, (JsonValue)JsonProviderHolder.get().createValue(meter.getMeanRate()));
        map.put("oneMinRate" + tags, (JsonValue)JsonProviderHolder.get().createValue(meter.getOneMinuteRate()));
        map.put("fiveMinRate" + tags, (JsonValue)JsonProviderHolder.get().createValue(meter.getFiveMinuteRate()));
        map.put("fifteenMinRate" + tags, (JsonValue)JsonProviderHolder.get().createValue(meter.getFifteenMinuteRate()));
        return map;
    }

    private Map<String, JsonValue> exportConcurrentGauge(ConcurrentGauge concurrentGauge, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("current" + tags, (JsonValue)JsonProviderHolder.get().createValue(concurrentGauge.getCount()));
        map.put("max" + tags, (JsonValue)JsonProviderHolder.get().createValue(concurrentGauge.getMax()));
        map.put("min" + tags, (JsonValue)JsonProviderHolder.get().createValue(concurrentGauge.getMin()));
        return map;
    }

    private JsonObject exportSimpleTimer(SimpleTimer timer, String unit, String tags) {
        JsonObjectBuilder builder = JsonProviderHolder.get().createObjectBuilder();
        builder.add("count" + tags, timer.getCount());
        builder.add("elapsedTime" + tags, this.toBase(timer.getElapsedTime().toNanos(), unit).doubleValue());
        Duration minTimeDuration = timer.getMinTimeDuration();
        if (minTimeDuration != null) {
            builder.add("minTimeDuration" + tags, this.toBase(minTimeDuration.toNanos(), unit).doubleValue());
        } else {
            builder.add("minTimeDuration" + tags, JsonValue.NULL);
        }
        Duration maxTimeDuration = timer.getMaxTimeDuration();
        if (maxTimeDuration != null) {
            builder.add("maxTimeDuration" + tags, this.toBase(maxTimeDuration.toNanos(), unit).doubleValue());
        } else {
            builder.add("maxTimeDuration" + tags, JsonValue.NULL);
        }
        return builder.build();
    }

    private JsonObject exportTimer(Timer timer, String unit, String tags) {
        JsonObjectBuilder builder = JsonProviderHolder.get().createObjectBuilder();
        this.snapshotValues(timer.getSnapshot(), unit, tags).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        this.meterValues((Metered)timer, tags).forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        builder.add("elapsedTime" + tags, this.toBase(timer.getElapsedTime().toNanos(), unit).doubleValue());
        return builder.build();
    }

    private Map<String, JsonValue> exportHistogram(Histogram histogram, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("count" + tags, (JsonValue)JsonProviderHolder.get().createValue(histogram.getCount()));
        map.put("sum" + tags, (JsonValue)JsonProviderHolder.get().createValue(histogram.getSum()));
        this.snapshotValues(histogram.getSnapshot(), tags).forEach(map::put);
        return map;
    }

    private Map<String, JsonValue> snapshotValues(Snapshot snapshot, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("p50" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.getMedian()));
        map.put("p75" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.get75thPercentile()));
        map.put("p95" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.get95thPercentile()));
        map.put("p98" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.get98thPercentile()));
        map.put("p99" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.get99thPercentile()));
        map.put("p999" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.get999thPercentile()));
        map.put("min" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.getMin()));
        map.put("mean" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.getMean()));
        map.put("max" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.getMax()));
        map.put("stddev" + tags, (JsonValue)JsonProviderHolder.get().createValue(snapshot.getStdDev()));
        return map;
    }

    private Map<String, JsonValue> snapshotValues(Snapshot snapshot, String unit, String tags) {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        map.put("p50" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.getMedian(), unit).doubleValue()));
        map.put("p75" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.get75thPercentile(), unit).doubleValue()));
        map.put("p95" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.get95thPercentile(), unit).doubleValue()));
        map.put("p98" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.get98thPercentile(), unit).doubleValue()));
        map.put("p99" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.get99thPercentile(), unit).doubleValue()));
        map.put("p999" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.get999thPercentile(), unit).doubleValue()));
        map.put("min" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.getMin(), unit).doubleValue()));
        map.put("mean" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.getMean(), unit).doubleValue()));
        map.put("max" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.getMax(), unit).doubleValue()));
        map.put("stddev" + tags, (JsonValue)JsonProviderHolder.get().createValue(this.toBase(snapshot.getStdDev(), unit).doubleValue()));
        return map;
    }

    private Double toBase(Number count, String unit) {
        return ExporterUtil.convertNanosTo(count.doubleValue(), unit);
    }

    private Number getValueFromMetric(Metric theMetric, String name) {
        if (theMetric instanceof Gauge) {
            Number value = (Number)((Gauge)theMetric).getValue();
            if (value != null) {
                return value;
            }
            return 0;
        }
        if (theMetric instanceof Counter) {
            return ((Counter)theMetric).getCount();
        }
        return null;
    }

    private String createTagsString(Map<String, String> tags) {
        if (tags == null) {
            return "";
        }
        TreeMap<String, String> withGlobalTags = new TreeMap<String, String>(tags);
        withGlobalTags.putAll(this.globalTags);
        if (withGlobalTags.isEmpty()) {
            return "";
        }
        return ";" + withGlobalTags.entrySet().stream().map(tag -> (String)tag.getKey() + "=" + ((String)tag.getValue()).replaceAll(";", "_")).collect(Collectors.joining(";"));
    }
}

