/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.common;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronIdentityHandler
implements HttpHandler {
    public static final AttachmentKey<SecurityIdentity> IDENTITY_KEY = AttachmentKey.create(SecurityIdentity.class);
    private final HttpHandler next;

    public ElytronIdentityHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityIdentity securityIdentity = exchange.getAttachment(IDENTITY_KEY);
        if (securityIdentity == null) {
            this.next.handleRequest(exchange);
        } else {
            securityIdentity.runAs(() -> {
                this.next.handleRequest(exchange);
                return null;
            });
        }
    }
}

