/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect;

import io.netty.channel.ChannelHandler;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.remoting.CertificateUtil;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBasePlugin;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerQueuePlugin;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.broker.ActiveMQProtonRemotingConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionChannelHandler;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnectionManager;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerAggregation;
import org.apache.activemq.artemis.protocol.amqp.connect.mirror.AMQPMirrorControllerSource;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolLogger;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.activemq.artemis.protocol.amqp.proton.SenderController;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASL;
import org.apache.activemq.artemis.protocol.amqp.sasl.ClientSASLFactory;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.utils.ConfigurationHelper;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Receiver;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.Session;
import org.jboss.logging.Logger;

public class AMQPBrokerConnection
implements ClientConnectionLifeCycleListener,
ActiveMQServerQueuePlugin,
BrokerConnection {
    private static final Logger logger = Logger.getLogger(AMQPBrokerConnection.class);
    private final AMQPBrokerConnectConfiguration brokerConnectConfiguration;
    private final ProtonProtocolManager protonProtocolManager;
    private final ActiveMQServer server;
    private final NettyConnector bridgesConnector;
    private NettyConnection connection;
    private Session session;
    private AMQPSessionContext sessionContext;
    private ActiveMQProtonRemotingConnection protonRemotingConnection;
    private volatile boolean started = false;
    private final AMQPBrokerConnectionManager bridgeManager;
    private int retryCounter = 0;
    private boolean connecting = false;
    private volatile ScheduledFuture reconnectFuture;
    private Set<Queue> senders = new HashSet<Queue>();
    private Set<Queue> receivers = new HashSet<Queue>();
    final Executor connectExecutor;
    final ScheduledExecutorService scheduledExecutorService;
    String host;
    int port;
    private static final String EXTERNAL = "EXTERNAL";
    private static final String PLAIN = "PLAIN";
    private static final String ANONYMOUS = "ANONYMOUS";
    private static final byte[] EMPTY = new byte[0];

    public AMQPBrokerConnection(AMQPBrokerConnectionManager bridgeManager, AMQPBrokerConnectConfiguration brokerConnectConfiguration, ProtonProtocolManager protonProtocolManager, ActiveMQServer server, NettyConnector bridgesConnector) {
        this.bridgeManager = bridgeManager;
        this.brokerConnectConfiguration = brokerConnectConfiguration;
        this.protonProtocolManager = protonProtocolManager;
        this.server = server;
        this.bridgesConnector = bridgesConnector;
        this.connectExecutor = server.getExecutorFactory().getExecutor();
        this.scheduledExecutorService = server.getScheduledPool();
    }

    public String getName() {
        return this.brokerConnectConfiguration.getName();
    }

    public String getProtocol() {
        return "AMQP";
    }

    public boolean isStarted() {
        return this.started;
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        if (this.protonRemotingConnection != null) {
            this.protonRemotingConnection.fail(new ActiveMQException("Stopping Broker Connection"));
            this.protonRemotingConnection = null;
            this.connection = null;
        }
        ScheduledFuture scheduledFuture = this.reconnectFuture;
        this.reconnectFuture = null;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
    }

    public void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        this.server.getConfiguration().registerBrokerPlugin((ActiveMQServerBasePlugin)this);
        try {
            if (this.brokerConnectConfiguration != null && this.brokerConnectConfiguration.getConnectionElements() != null) {
                for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                    if (connectionElement.getType() != AMQPBrokerConnectionAddressType.MIRROR) continue;
                    AMQPBrokerConnection.installMirrorController(this, (AMQPMirrorBrokerConnectionElement)connectionElement, this.server);
                }
            }
        }
        catch (Throwable e) {
            logger.warn((Object)e.getMessage(), e);
            return;
        }
        this.connectExecutor.execute(() -> this.doConnect());
    }

    public NettyConnection getConnection() {
        return this.connection;
    }

    public void afterCreateQueue(Queue queue) {
        this.connectExecutor.execute(() -> {
            for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                this.validateMatching(queue, connectionElement);
            }
        });
    }

    public void validateMatching(Queue queue, AMQPBrokerConnectionElement connectionElement) {
        if (connectionElement.getType() != AMQPBrokerConnectionAddressType.MIRROR) {
            if (connectionElement.getQueueName() != null) {
                if (queue.getName().equals((Object)connectionElement.getQueueName())) {
                    this.createLink(queue, connectionElement);
                }
            } else if (connectionElement.match(queue.getAddress(), this.server.getConfiguration().getWildcardConfiguration())) {
                this.createLink(queue, connectionElement);
            }
        }
    }

    public void createLink(Queue queue, AMQPBrokerConnectionElement connectionElement) {
        if (connectionElement.getType() == AMQPBrokerConnectionAddressType.PEER) {
            this.connectSender(queue, queue.getAddress().toString(), Symbol.valueOf((String)"qd.waypoint"));
            this.connectReceiver(this.protonRemotingConnection, this.session, this.sessionContext, queue, Symbol.valueOf((String)"qd.waypoint"));
        } else {
            if (connectionElement.getType() == AMQPBrokerConnectionAddressType.SENDER) {
                this.connectSender(queue, queue.getAddress().toString(), new Symbol[0]);
            }
            if (connectionElement.getType() == AMQPBrokerConnectionAddressType.RECEIVER) {
                this.connectReceiver(this.protonRemotingConnection, this.session, this.sessionContext, queue, new Symbol[0]);
            }
        }
    }

    private void doConnect() {
        try {
            this.connecting = true;
            List configurationList = this.brokerConnectConfiguration.getTransportConfigurations();
            TransportConfiguration tpConfig = (TransportConfiguration)configurationList.get(0);
            String hostOnParameter = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)tpConfig.getParams());
            int portOnParameter = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)tpConfig.getParams());
            this.host = hostOnParameter;
            this.port = portOnParameter;
            this.connection = this.bridgesConnector.createConnection(null, hostOnParameter, portOnParameter);
            if (this.connection == null) {
                this.retryConnection();
                return;
            }
            int currentRetryCounter = this.retryCounter;
            this.reconnectFuture = null;
            this.retryCounter = 0;
            this.senders.clear();
            this.receivers.clear();
            SaslFactory saslFactory = new SaslFactory(this.connection, this.brokerConnectConfiguration);
            ConnectionEntry entry = this.protonProtocolManager.createOutgoingConnectionEntry((Connection)this.connection, saslFactory);
            this.server.getRemotingService().addConnectionEntry((Connection)this.connection, entry);
            this.protonRemotingConnection = (ActiveMQProtonRemotingConnection)entry.connection;
            this.connection.getChannel().pipeline().addLast(new ChannelHandler[]{new AMQPBrokerConnectionChannelHandler(this.bridgesConnector.getChannelGroup(), this.protonRemotingConnection.getAmqpConnection().getHandler(), this, (Executor)this.server.getExecutorFactory().getExecutor())});
            this.session = this.protonRemotingConnection.getAmqpConnection().getHandler().getConnection().session();
            this.sessionContext = this.protonRemotingConnection.getAmqpConnection().getSessionExtension(this.session);
            this.protonRemotingConnection.getAmqpConnection().runLater(() -> {
                this.protonRemotingConnection.getAmqpConnection().open();
                this.session.open();
                this.protonRemotingConnection.getAmqpConnection().flush();
            });
            if (this.brokerConnectConfiguration.getConnectionElements() != null) {
                Stream bindingStream = this.server.getPostOffice().getAllBindings();
                bindingStream.forEach(binding -> {
                    if (binding instanceof QueueBinding) {
                        Queue queue = ((QueueBinding)binding).getQueue();
                        for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                            this.validateMatching(queue, connectionElement);
                        }
                    }
                });
                for (AMQPBrokerConnectionElement connectionElement : this.brokerConnectConfiguration.getConnectionElements()) {
                    if (connectionElement.getType() != AMQPBrokerConnectionAddressType.MIRROR) continue;
                    AMQPMirrorBrokerConnectionElement replica = (AMQPMirrorBrokerConnectionElement)connectionElement;
                    Queue queue = this.server.locateQueue(replica.getSourceMirrorAddress());
                    this.connectSender(queue, "$ACTIVEMQ_ARTEMIS_MIRROR", new Symbol[0]);
                }
            }
            this.protonRemotingConnection.getAmqpConnection().flush();
            this.bridgeManager.connected(this.connection, this);
            ActiveMQAMQPProtocolLogger.LOGGER.successReconnect(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, currentRetryCounter);
            this.connecting = false;
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    public void retryConnection() {
        if (this.bridgeManager.isStarted() && this.started) {
            if (this.brokerConnectConfiguration.getReconnectAttempts() < 0 || this.retryCounter < this.brokerConnectConfiguration.getReconnectAttempts()) {
                ++this.retryCounter;
                ActiveMQAMQPProtocolLogger.LOGGER.retryConnection(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, this.retryCounter, this.brokerConnectConfiguration.getReconnectAttempts());
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reconnecting in " + this.brokerConnectConfiguration.getRetryInterval() + ", this is the " + this.retryCounter + " of " + this.brokerConnectConfiguration.getReconnectAttempts()));
                }
                this.reconnectFuture = this.scheduledExecutorService.schedule(() -> this.connectExecutor.execute(() -> this.doConnect()), (long)this.brokerConnectConfiguration.getRetryInterval(), TimeUnit.MILLISECONDS);
            } else {
                this.connecting = false;
                ActiveMQAMQPProtocolLogger.LOGGER.retryConnectionFailed(this.brokerConnectConfiguration.getName(), this.host + ":" + this.port, this.retryCounter);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("no more reconnections as the retry counter reached " + this.retryCounter + " out of " + this.brokerConnectConfiguration.getReconnectAttempts()));
                }
            }
        }
    }

    private static void uninstallMirrorController(AMQPMirrorBrokerConnectionElement replicaConfig, ActiveMQServer server) {
    }

    private static Queue installMirrorController(AMQPBrokerConnection brokerConnection, AMQPMirrorBrokerConnectionElement replicaConfig, ActiveMQServer server) throws Exception {
        AddressInfo addressInfo;
        MirrorController currentMirrorController = server.getMirrorController();
        if (currentMirrorController != null && currentMirrorController instanceof AMQPMirrorControllerSource) {
            Queue queue = AMQPBrokerConnection.checkCurrentMirror(brokerConnection, (AMQPMirrorControllerSource)currentMirrorController);
            if (queue != null) {
                return queue;
            }
        } else if (currentMirrorController != null && currentMirrorController instanceof AMQPMirrorControllerAggregation) {
            AMQPMirrorControllerAggregation aggregation = (AMQPMirrorControllerAggregation)currentMirrorController;
            for (AMQPMirrorControllerSource source : aggregation.getPartitions()) {
                Queue queue = AMQPBrokerConnection.checkCurrentMirror(brokerConnection, source);
                if (queue == null) continue;
                return queue;
            }
        }
        if ((addressInfo = server.getAddressInfo(replicaConfig.getSourceMirrorAddress())) == null) {
            addressInfo = new AddressInfo(replicaConfig.getSourceMirrorAddress()).addRoutingType(RoutingType.ANYCAST).setAutoCreated(false).setTemporary(!replicaConfig.isDurable());
            server.addAddressInfo(addressInfo);
        }
        if (addressInfo.getRoutingType() != RoutingType.ANYCAST) {
            throw new IllegalArgumentException("sourceMirrorAddress is not ANYCAST");
        }
        Queue mirrorControlQueue = server.locateQueue(replicaConfig.getSourceMirrorAddress());
        if (mirrorControlQueue == null) {
            mirrorControlQueue = server.createQueue(new QueueConfiguration(replicaConfig.getSourceMirrorAddress()).setAddress(replicaConfig.getSourceMirrorAddress()).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(replicaConfig.isDurable())), true);
        }
        mirrorControlQueue.setMirrorController(true);
        QueueBinding snfReplicaQueueBinding = (QueueBinding)server.getPostOffice().getBinding(replicaConfig.getSourceMirrorAddress());
        if (snfReplicaQueueBinding == null) {
            logger.warn((Object)("Queue does not exist even after creation! " + replicaConfig));
            throw new IllegalAccessException("Cannot start replica");
        }
        Queue snfQueue = snfReplicaQueueBinding.getQueue();
        if (!snfQueue.getAddress().equals((Object)replicaConfig.getSourceMirrorAddress())) {
            logger.warn((Object)("Queue " + snfQueue + " belong to a different address (" + snfQueue.getAddress() + "), while we expected it to be " + addressInfo.getName()));
            throw new IllegalAccessException("Cannot start replica");
        }
        AMQPMirrorControllerSource newPartition = new AMQPMirrorControllerSource(snfQueue, server, replicaConfig.isMessageAcknowledgements(), replicaConfig.isQueueCreation(), replicaConfig.isQueueRemoval(), brokerConnection);
        server.scanAddresses((MirrorController)newPartition);
        if (currentMirrorController == null) {
            server.installMirrorController((MirrorController)newPartition);
        } else {
            if (currentMirrorController instanceof AMQPMirrorControllerSource) {
                AMQPMirrorControllerAggregation remoteAggregation = new AMQPMirrorControllerAggregation();
                remoteAggregation.addPartition((AMQPMirrorControllerSource)currentMirrorController);
                currentMirrorController = remoteAggregation;
                server.installMirrorController((MirrorController)remoteAggregation);
            }
            ((AMQPMirrorControllerAggregation)currentMirrorController).addPartition(newPartition);
        }
        return snfQueue;
    }

    private static Queue checkCurrentMirror(AMQPBrokerConnection brokerConnection, AMQPMirrorControllerSource currentMirrorController) {
        AMQPMirrorControllerSource source = currentMirrorController;
        if (source.getBrokerConnection() == brokerConnection) {
            return source.getSnfQueue();
        }
        return null;
    }

    private void connectReceiver(ActiveMQProtonRemotingConnection protonRemotingConnection, Session session, AMQPSessionContext sessionContext, Queue queue, Symbol ... capabilities) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connecting inbound for " + queue));
        }
        if (session == null) {
            logger.debug((Object)"session is null");
            return;
        }
        protonRemotingConnection.getAmqpConnection().runLater(() -> {
            if (this.receivers.contains(queue)) {
                logger.debug((Object)("Receiver for queue " + queue + " already exists, just giving up"));
                return;
            }
            this.receivers.add(queue);
            Receiver receiver = session.receiver(queue.getAddress().toString() + ":" + UUIDGenerator.getInstance().generateStringUUID());
            receiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            Target target = new Target();
            target.setAddress(queue.getAddress().toString());
            receiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
            Source source = new Source();
            source.setAddress(queue.getAddress().toString());
            receiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            if (capabilities != null) {
                source.setCapabilities(capabilities);
            }
            receiver.open();
            protonRemotingConnection.getAmqpConnection().flush();
            try {
                sessionContext.addReceiver(receiver);
            }
            catch (Exception e) {
                this.error(e);
            }
        });
    }

    private void connectSender(Queue queue, String targetName, Symbol ... capabilities) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Connecting outbound for " + queue));
        }
        if (this.session == null) {
            logger.debug((Object)"Session is null");
            return;
        }
        this.protonRemotingConnection.getAmqpConnection().runLater(() -> {
            try {
                if (this.senders.contains(queue)) {
                    logger.debug((Object)("Sender for queue " + queue + " already exists, just giving up"));
                    return;
                }
                this.senders.add(queue);
                Sender sender = this.session.sender(targetName + ":" + UUIDGenerator.getInstance().generateStringUUID());
                sender.setSenderSettleMode(SenderSettleMode.UNSETTLED);
                sender.setReceiverSettleMode(ReceiverSettleMode.FIRST);
                Target target = new Target();
                target.setAddress(targetName);
                if (capabilities != null) {
                    target.setCapabilities(capabilities);
                }
                sender.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
                Source source = new Source();
                source.setAddress(queue.getAddress().toString());
                sender.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
                AMQPOutgoingController outgoingInitializer = new AMQPOutgoingController(queue, sender, this.sessionContext.getSessionSPI());
                ProtonServerSenderContext senderContext = new ProtonServerSenderContext(this.protonRemotingConnection.getAmqpConnection(), sender, this.sessionContext, this.sessionContext.getSessionSPI(), outgoingInitializer);
                this.sessionContext.addSender(sender, senderContext);
            }
            catch (Exception e) {
                this.error(e);
            }
            this.protonRemotingConnection.getAmqpConnection().flush();
        });
    }

    protected void error(Throwable e) {
        this.connecting = false;
        logger.warn((Object)e.getMessage(), e);
        this.redoConnection();
    }

    public void disconnect() throws Exception {
        this.redoConnection();
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
    }

    public void connectionDestroyed(Object connectionID) {
        this.server.getRemotingService().removeConnection(connectionID);
        this.redoConnection();
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        this.redoConnection();
    }

    private void redoConnection() {
        this.connectExecutor.execute(() -> {
            if (this.connecting) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Broker connection " + this.getName() + " was already in retry mode, exception or retry not captured"));
                }
                return;
            }
            this.connecting = true;
            try {
                if (this.protonRemotingConnection != null) {
                    this.protonRemotingConnection.fail(new ActiveMQException("Connection being recreated"));
                    this.connection = null;
                    this.protonRemotingConnection = null;
                }
            }
            catch (Throwable e) {
                logger.warn((Object)e.getMessage(), e);
            }
            this.retryConnection();
        });
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
        this.protonRemotingConnection.flush();
    }

    private static final class SaslFactory
    implements ClientSASLFactory {
        private final NettyConnection connection;
        private final AMQPBrokerConnectConfiguration brokerConnectConfiguration;

        SaslFactory(NettyConnection connection, AMQPBrokerConnectConfiguration brokerConnectConfiguration) {
            this.connection = connection;
            this.brokerConnectConfiguration = brokerConnectConfiguration;
        }

        @Override
        public ClientSASL chooseMechanism(String[] offeredMechanims) {
            List<Object> availableMechanisms;
            List<Object> list = availableMechanisms = offeredMechanims == null ? Collections.emptyList() : Arrays.asList(offeredMechanims);
            if (availableMechanisms.contains(AMQPBrokerConnection.EXTERNAL) && ExternalSASLMechanism.isApplicable(this.connection)) {
                return new ExternalSASLMechanism();
            }
            if (availableMechanisms.contains(AMQPBrokerConnection.PLAIN) && PlainSASLMechanism.isApplicable(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword())) {
                return new PlainSASLMechanism(this.brokerConnectConfiguration.getUser(), this.brokerConnectConfiguration.getPassword());
            }
            if (availableMechanisms.contains(AMQPBrokerConnection.ANONYMOUS)) {
                return new AnonymousSASLMechanism();
            }
            return null;
        }
    }

    private static class ExternalSASLMechanism
    implements ClientSASL {
        private ExternalSASLMechanism() {
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.EXTERNAL;
        }

        @Override
        public byte[] getInitialResponse() {
            return EMPTY;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }

        public static boolean isApplicable(NettyConnection connection) {
            return CertificateUtil.getLocalPrincipalFromConnection((NettyConnection)connection) != null;
        }
    }

    private static class AnonymousSASLMechanism
    implements ClientSASL {
        private AnonymousSASLMechanism() {
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.ANONYMOUS;
        }

        @Override
        public byte[] getInitialResponse() {
            return EMPTY;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }
    }

    private static class PlainSASLMechanism
    implements ClientSASL {
        private final byte[] initialResponse;

        PlainSASLMechanism(String username, String password) {
            byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
            byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
            byte[] encoded = new byte[usernameBytes.length + passwordBytes.length + 2];
            System.arraycopy(usernameBytes, 0, encoded, 1, usernameBytes.length);
            System.arraycopy(passwordBytes, 0, encoded, usernameBytes.length + 2, passwordBytes.length);
            this.initialResponse = encoded;
        }

        @Override
        public String getName() {
            return AMQPBrokerConnection.PLAIN;
        }

        @Override
        public byte[] getInitialResponse() {
            return this.initialResponse;
        }

        @Override
        public byte[] getResponse(byte[] challenge) {
            return EMPTY;
        }

        public static boolean isApplicable(String username, String password) {
            return username != null && username.length() > 0 && password != null && password.length() > 0;
        }
    }

    private class AMQPOutgoingController
    implements SenderController {
        final Queue queue;
        final Sender sender;
        final AMQPSessionCallback sessionSPI;

        AMQPOutgoingController(Queue queue, Sender sender, AMQPSessionCallback sessionSPI) {
            this.queue = queue;
            this.sessionSPI = sessionSPI;
            this.sender = sender;
        }

        @Override
        public Consumer init(ProtonServerSenderContext senderContext) throws Exception {
            SimpleString queueName = this.queue.getName();
            return (Consumer)this.sessionSPI.createSender(senderContext, queueName, null, false);
        }

        @Override
        public void close() throws Exception {
        }
    }
}

