/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReference;

public class UniOnCancellation<T>
extends UniOperator<T, T> {
    private final Runnable callback;

    public UniOnCancellation(Uni<T> upstream, Runnable callback) {
        super(upstream);
        this.callback = callback;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnCancellationProcessor(subscriber));
    }

    private class UniOnCancellationProcessor
    extends UniOperatorProcessor<T, T> {
        private final AtomicReference<State> state;

        public UniOnCancellationProcessor(UniSubscriber<? super T> downstream) {
            super(downstream);
            this.state = new AtomicReference<State>(State.INIT);
        }

        @Override
        public void onItem(T item) {
            if (this.state.compareAndSet(State.INIT, State.DONE)) {
                this.downstream.onItem(item);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.state.compareAndSet(State.INIT, State.DONE)) {
                this.downstream.onFailure(failure);
            }
        }

        @Override
        public void cancel() {
            if (this.state.compareAndSet(State.INIT, State.CANCELLED)) {
                UniSubscription sub = this.upstream.getAndSet(EmptyUniSubscription.CANCELLED);
                UniOnCancellation.this.callback.run();
                if (sub != null) {
                    sub.cancel();
                }
            }
        }
    }

    private static enum State {
        INIT,
        DONE,
        CANCELLED;

    }
}

