/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.idm.Account;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexSerializer;
import org.wildfly.extension.undertow.security.AccountImpl;

public class AuthenticatedSessionExternalizer
implements Externalizer<AuthenticatedSessionManager.AuthenticatedSession> {
    public void writeObject(ObjectOutput output, AuthenticatedSessionManager.AuthenticatedSession session) throws IOException {
        AccountImpl account = (AccountImpl)session.getAccount();
        output.writeUTF(session.getMechanism());
        output.writeUTF(account.getPrincipal().getName());
        Set roles = account.getRoles();
        IndexSerializer.VARIABLE.writeInt((DataOutput)output, roles.size());
        for (String role : roles) {
            output.writeUTF(role);
        }
        output.writeObject(account.getCredential());
        Principal original = account.getOriginalPrincipal();
        output.writeUTF(original != null ? original.getName() : null);
    }

    public AuthenticatedSessionManager.AuthenticatedSession readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        String mechanism = input.readUTF();
        Principal principal = new AccountImpl(input.readUTF()).getPrincipal();
        int roleCount = IndexSerializer.VARIABLE.readInt((DataInput)input);
        ArrayList<String> roles = new ArrayList<String>(roleCount);
        for (int i = 0; i < roleCount; ++i) {
            roles.add(input.readUTF());
        }
        Object credential = input.readObject();
        Principal original = new AccountImpl(input.readUTF()).getPrincipal();
        AccountImpl account = new AccountImpl(principal, new CopyOnWriteArraySet(roles), credential, original);
        return new AuthenticatedSessionManager.AuthenticatedSession((Account)account, mechanism);
    }

    public Class<AuthenticatedSessionManager.AuthenticatedSession> getTargetClass() {
        return AuthenticatedSessionManager.AuthenticatedSession.class;
    }
}

