/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.CoreQueueConfiguration;

public class CoreAddressConfiguration
implements Serializable {
    private String name = null;
    private EnumSet<RoutingType> routingTypes = EnumSet.noneOf(RoutingType.class);
    private List<QueueConfiguration> queueConfigurations = new ArrayList<QueueConfiguration>();

    public String getName() {
        return this.name;
    }

    public CoreAddressConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public EnumSet<RoutingType> getRoutingTypes() {
        return this.routingTypes;
    }

    public CoreAddressConfiguration addRoutingType(RoutingType routingType) {
        this.routingTypes.add(routingType);
        return this;
    }

    @Deprecated
    public CoreAddressConfiguration setQueueConfigurations(List<CoreQueueConfiguration> coreQueueConfigurations) {
        for (CoreQueueConfiguration coreQueueConfiguration : coreQueueConfigurations) {
            this.queueConfigurations.add(coreQueueConfiguration.toQueueConfiguration());
        }
        return this;
    }

    public CoreAddressConfiguration setQueueConfigs(List<QueueConfiguration> queueConfigurations) {
        this.queueConfigurations = queueConfigurations;
        return this;
    }

    public CoreAddressConfiguration addQueueConfiguration(CoreQueueConfiguration queueConfiguration) {
        this.queueConfigurations.add(queueConfiguration.toQueueConfiguration());
        return this;
    }

    public CoreAddressConfiguration addQueueConfiguration(QueueConfiguration queueConfiguration) {
        this.queueConfigurations.add(queueConfiguration);
        return this;
    }

    @Deprecated
    public List<CoreQueueConfiguration> getQueueConfigurations() {
        ArrayList<CoreQueueConfiguration> result = new ArrayList<CoreQueueConfiguration>();
        for (QueueConfiguration queueConfiguration : this.queueConfigurations) {
            result.add(CoreQueueConfiguration.fromQueueConfiguration(queueConfiguration));
        }
        return result;
    }

    public List<QueueConfiguration> getQueueConfigs() {
        return this.queueConfigurations;
    }

    public String toString() {
        return "CoreAddressConfiguration[name=" + this.name + ", routingTypes=" + this.routingTypes + ", queueConfigurations=" + this.queueConfigurations + "]";
    }
}

