/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntFunction;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateIdException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.impl.ByteArray;
import org.apache.activemq.artemis.core.postoffice.impl.IntegerCache;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.jboss.logging.Logger;

final class InMemoryDuplicateIDCache
implements DuplicateIDCache {
    private static final Logger LOGGER = Logger.getLogger(InMemoryDuplicateIDCache.class);
    private final Map<ByteArray, Integer> cache = new ConcurrentHashMap<ByteArray, Integer>();
    private final SimpleString address;
    private final ArrayList<ByteArray> ids;
    private final IntFunction<Integer> cachedBoxedInts;
    private int pos;
    private final int cacheSize;

    InMemoryDuplicateIDCache(SimpleString address, int size) {
        this.address = address;
        this.cacheSize = size;
        this.ids = new ArrayList(size);
        this.cachedBoxedInts = IntegerCache.boxedInts(size);
    }

    @Override
    public void load(List<Pair<byte[], Long>> ids) throws Exception {
        LOGGER.debugf("address = %s ignore loading ids: in memory cache won't load previously stored ids", (Object)this.address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromCache(byte[] duplicateID) {
        ByteArray bah;
        Integer posUsed;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("deleting id = %s", (Object)InMemoryDuplicateIDCache.describeID(duplicateID));
        }
        if ((posUsed = this.cache.remove(bah = new ByteArray(duplicateID))) != null) {
            InMemoryDuplicateIDCache inMemoryDuplicateIDCache = this;
            synchronized (inMemoryDuplicateIDCache) {
                int index = posUsed;
                ByteArray id = this.ids.get(index);
                if (id.equals(bah)) {
                    this.ids.set(index, null);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.tracef("address = %s deleting id=", (Object)this.address, (Object)InMemoryDuplicateIDCache.describeID(duplicateID));
                    }
                }
            }
        }
    }

    private static String describeID(byte[] duplicateID) {
        return ByteUtil.bytesToHex((byte[])duplicateID, (int)4) + ", simpleString=" + ByteUtil.toSimpleString((byte[])duplicateID);
    }

    @Override
    public boolean contains(byte[] duplID) {
        return this.contains(new ByteArray(duplID));
    }

    private boolean contains(ByteArray id) {
        boolean contains = this.cache.containsKey(id);
        if (LOGGER.isTraceEnabled() && contains) {
            LOGGER.tracef("address = %s found a duplicate ", (Object)this.address, (Object)InMemoryDuplicateIDCache.describeID(id.bytes));
        }
        return contains;
    }

    @Override
    public void addToCache(byte[] duplID) throws Exception {
        this.addToCache(duplID, null, false);
    }

    @Override
    public void addToCache(byte[] duplID, Transaction tx) throws Exception {
        this.addToCache(duplID, tx, false);
    }

    @Override
    public synchronized boolean atomicVerify(byte[] duplID, Transaction tx) {
        ByteArray holder = new ByteArray(duplID);
        if (this.contains(holder)) {
            if (tx != null) {
                tx.markAsRollbackOnly((ActiveMQException)new ActiveMQDuplicateIdException());
            }
            return false;
        }
        this.addToCache(holder, tx, true);
        return true;
    }

    @Override
    public synchronized void addToCache(byte[] duplID, Transaction tx, boolean instantAdd) throws Exception {
        this.addToCache(new ByteArray(duplID), tx, instantAdd);
    }

    private synchronized void addToCache(ByteArray holder, Transaction tx, boolean instantAdd) {
        if (tx == null) {
            this.addToCacheInMemory(holder);
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracef("address = %s adding duplicateID TX operation for %s, tx = %s", (Object)this.address, (Object)InMemoryDuplicateIDCache.describeID(holder.bytes), (Object)tx);
            }
            if (instantAdd) {
                tx.addOperation(new AddDuplicateIDOperation(holder, false));
            } else {
                tx.afterStore(new AddDuplicateIDOperation(holder, true));
            }
        }
    }

    @Override
    public void load(Transaction tx, byte[] duplID) {
        tx.addOperation(new AddDuplicateIDOperation(new ByteArray(duplID), true));
    }

    private synchronized void addToCacheInMemory(ByteArray holder) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.tracef("address = %s adding %s", (Object)this.address, (Object)InMemoryDuplicateIDCache.describeID(holder.bytes));
        }
        this.cache.put(holder, this.cachedBoxedInts.apply(this.pos));
        if (this.pos < this.ids.size()) {
            ByteArray id = this.ids.set(this.pos, holder);
            if (id != null) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.tracef("address = %s removing excess duplicateDetection %s", (Object)this.address, (Object)InMemoryDuplicateIDCache.describeID(id.bytes));
                }
                this.cache.remove(id);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracef("address = %s replacing old duplicateID by %s", (Object)InMemoryDuplicateIDCache.describeID(holder.bytes));
            }
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.tracef("address = %s adding new duplicateID %s", (Object)InMemoryDuplicateIDCache.describeID(holder.bytes));
            }
            this.ids.add(holder);
        }
        if (this.pos++ == this.cacheSize - 1) {
            this.pos = 0;
        }
    }

    @Override
    public synchronized void clear() throws Exception {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debugf("address = %s removing duplicate ID data", (Object)this.address);
        }
        this.ids.clear();
        this.cache.clear();
        this.pos = 0;
    }

    @Override
    public synchronized List<Pair<byte[], Long>> getMap() {
        int idsSize = this.ids.size();
        ArrayList<Pair<byte[], Long>> copy = new ArrayList<Pair<byte[], Long>>(idsSize);
        for (int i = 0; i < idsSize; ++i) {
            ByteArray id = this.ids.get(i);
            if (id == null) continue;
            copy.add((Pair<byte[], Long>)new Pair((Object)id.bytes, null));
        }
        return copy;
    }

    private final class AddDuplicateIDOperation
    extends TransactionOperationAbstract {
        final ByteArray id;
        volatile boolean done;
        private final boolean afterCommit;

        AddDuplicateIDOperation(ByteArray id, boolean afterCommit) {
            this.id = id;
            this.afterCommit = afterCommit;
        }

        private void process() {
            if (!this.done) {
                InMemoryDuplicateIDCache.this.addToCacheInMemory(this.id);
                this.done = true;
            }
        }

        @Override
        public void afterCommit(Transaction tx) {
            if (this.afterCommit) {
                this.process();
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
            if (!this.afterCommit) {
                this.process();
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }
}

