/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager.transport.remote.jgroups;

import jakarta.resource.spi.work.DistributableWork;
import jakarta.resource.spi.work.WorkException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.workmanager.DistributedWorkManagerStatisticsValues;
import org.jboss.jca.core.workmanager.ClassBundle;
import org.jboss.jca.core.workmanager.WorkClassLoader;
import org.jboss.jca.core.workmanager.WorkObjectInputStream;
import org.jboss.jca.core.workmanager.transport.remote.AbstractRemoteTransport;
import org.jboss.jca.core.workmanager.transport.remote.ProtocolMessages;
import org.jboss.jca.core.workmanager.transport.remote.jgroups.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.MethodLookup;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class JGroupsTransport
extends AbstractRemoteTransport<Address>
implements MembershipListener {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)JGroupsTransport.class.getName());
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private Channel channel = null;
    private long timeout = 10000L;
    private String clusterName = null;
    private RpcDispatcher disp = null;
    private boolean initialized = false;
    private static final short JOIN_METHOD = 1;
    private static final short LEAVE_METHOD = 2;
    private static final short PING_METHOD = 3;
    private static final short GET_WORKMANAGERS_METHOD = 4;
    private static final short WORKMANAGER_ADD_METHOD = 5;
    private static final short WORKMANAGER_REMOVE_METHOD = 6;
    private static final short DO_WORK_METHOD = 7;
    private static final short START_WORK_METHOD = 8;
    private static final short SCHEDULE_WORK_METHOD = 9;
    private static final short GET_SHORTRUNNING_FREE_METHOD = 10;
    private static final short GET_LONGRUNNING_FREE_METHOD = 11;
    private static final short UPDATE_SHORTRUNNING_FREE_METHOD = 12;
    private static final short UPDATE_LONGRUNNING_FREE_METHOD = 13;
    private static final short GET_DISTRIBUTED_STATISTICS_METHOD = 14;
    private static final short CLEAR_DISTRIBUTED_STATISTICS_METHOD = 15;
    private static final short DELTA_DOWORK_ACCEPTED_METHOD = 16;
    private static final short DELTA_DOWORK_REJECTED_METHOD = 17;
    private static final short DELTA_STARTWORK_ACCEPTED_METHOD = 18;
    private static final short DELTA_STARTWORK_REJECTED_METHOD = 19;
    private static final short DELTA_SCHEDULEWORK_ACCEPTED_METHOD = 20;
    private static final short DELTA_SCHEDULEWORK_REJECTED_METHOD = 21;
    private static final short DELTA_WORK_SUCCESSFUL_METHOD = 22;
    private static final short DELTA_WORK_FAILED_METHOD = 23;
    private static Map<Short, Method> methods = new HashMap<Short, Method>();

    public void join(Map<String, String> logicalAddress, Address address) {
        org.jboss.jca.core.spi.workmanager.Address logicalAddressObj = org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddress);
        super.join(logicalAddressObj, address);
    }

    @Override
    public void leave(Address address) {
        super.leave(address);
    }

    public Set<Map<String, String>> getWorkManagers() {
        HashSet<Map<String, String>> setOfMaps = new HashSet<Map<String, String>>();
        for (org.jboss.jca.core.spi.workmanager.Address address : this.getAddresses(this.channel.getAddress())) {
            setOfMaps.add(address.toMap());
        }
        return setOfMaps;
    }

    public void addWorkManager(Map<String, String> logicalAddressMap, Address address) {
        org.jboss.jca.core.spi.workmanager.Address logicalAddress = org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap);
        super.localWorkManagerAdd(logicalAddress, address);
        Long shortRunning = this.getShortRunningFree(logicalAddress);
        Long longRunning = this.getLongRunningFree(logicalAddress);
        this.localUpdateShortRunningFree(logicalAddress, shortRunning);
        this.localUpdateLongRunningFree(logicalAddress, longRunning);
    }

    public void workManagerRemove(Map<String, String> logicalAddressMap) {
        super.localWorkManagerRemove(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public long getShortRunningFree(Map<String, String> logicalAddressMap) {
        return super.localGetShortRunningFree(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public long getLongRunningFree(Map<String, String> logicalAddressMap) {
        return super.localGetLongRunningFree(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void updateShortRunningFree(Map<String, String> logicalAddressMap, Long freeCount) {
        super.localUpdateShortRunningFree(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap), freeCount);
    }

    public void updateLongRunningFree(Map<String, String> logicalAddressMap, Long freeCount) {
        super.localUpdateLongRunningFree(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap), freeCount);
    }

    public Map<String, Integer> getDistributedStatistics(Map<String, String> logicalAddressMap) {
        return super.localGetDistributedStatistics(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap)).toMap();
    }

    public void clearDistributedStatistics(Map<String, String> logicalAddressMap) {
        super.localClearDistributedStatistics(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void deltaDoWorkAccepted(Map<String, String> logicalAddressMap) {
        super.localDeltaDoWorkAccepted(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void deltaDoWorkRejected(Map<String, String> logicalAddressMap) {
        super.localDeltaDoWorkRejected(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void deltaStartWorkAccepted(Map<String, String> logicalAddressMap) {
        super.localDeltaStartWorkAccepted(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void deltaStartWorkRejected(Map<String, String> logicalAddressMap) {
        super.localDeltaStartWorkRejected(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void deltaScheduleWorkAccepted(Map<String, String> logicalAddressMap) {
        super.localDeltaScheduleWorkAccepted(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void deltaScheduleWorkRejected(Map<String, String> logicalAddressMap) {
        super.localDeltaScheduleWorkRejected(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void deltaWorkSuccessful(Map<String, String> logicalAddressMap) {
        super.localDeltaWorkSuccessful(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void deltaWorkFailed(Map<String, String> logicalAddressMap) {
        super.localDeltaWorkSuccessful(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap));
    }

    public void executeDoWork(Map<String, String> logicalAddressMap, List<Map<String, Object>> classBundle, byte[] b) throws RemoteException {
        ByteArrayInputStream bias = new ByteArrayInputStream(b);
        ObjectInputStream wois = null;
        try {
            WorkClassLoader wcl = SecurityActions.createWorkClassLoader(ClassBundle.fromListOfMaps(classBundle));
            wois = new WorkObjectInputStream(bias, wcl);
            DistributableWork dw = (DistributableWork)wois.readObject();
            this.localDoWork(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap), dw);
        }
        catch (Throwable t) {
            throw new RemoteException("Error during doWork: " + t.getMessage());
        }
        finally {
            if (wois != null) {
                try {
                    wois.close();
                }
                catch (IOException wcl) {}
            }
        }
    }

    public long executeStartWork(Map<String, String> logicalAddressMap, List<Map<String, Object>> classBundle, byte[] b) throws RemoteException {
        ByteArrayInputStream bias = new ByteArrayInputStream(b);
        ObjectInputStream wois = null;
        try {
            WorkClassLoader wcl = SecurityActions.createWorkClassLoader(ClassBundle.fromListOfMaps(classBundle));
            wois = new WorkObjectInputStream(bias, wcl);
            DistributableWork dw = (DistributableWork)wois.readObject();
            long l = this.localStartWork(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddressMap), dw);
            return l;
        }
        catch (Throwable t) {
            throw new RemoteException("Error during doWork: " + t.getMessage());
        }
        finally {
            if (wois != null) {
                try {
                    wois.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void executeScheduleWork(Map<String, String> logicalAddress, List<Map<String, Object>> classBundle, byte[] b) throws RemoteException {
        ByteArrayInputStream bias = new ByteArrayInputStream(b);
        ObjectInputStream wois = null;
        try {
            WorkClassLoader wcl = SecurityActions.createWorkClassLoader(ClassBundle.fromListOfMaps(classBundle));
            wois = new WorkObjectInputStream(bias, wcl);
            DistributableWork dw = (DistributableWork)wois.readObject();
            this.localScheduleWork(org.jboss.jca.core.spi.workmanager.Address.fromMap(logicalAddress), dw);
        }
        catch (Throwable t) {
            throw new RemoteException("Error during doWork: " + t.getMessage());
        }
        finally {
            if (wois != null) {
                try {
                    wois.close();
                }
                catch (IOException wcl) {}
            }
        }
    }

    public void startup() throws Throwable {
        this.disp = this.createRpcDispatcher();
        if (this.clusterName == null) {
            this.clusterName = "jca";
        }
        this.channel.connect(this.clusterName);
    }

    protected RpcDispatcher createRpcDispatcher() {
        RpcDispatcher dispatcher = new RpcDispatcher(this.channel, null, (MembershipListener)this, (Object)this);
        dispatcher.setMethodLookup(new MethodLookup(){

            public Method findMethod(short key) {
                return (Method)methods.get(key);
            }
        });
        return dispatcher;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() throws Throwable {
        this.initialized = true;
    }

    public void shutdown() throws Throwable {
        if (this.disp != null) {
            block8: {
                try {
                    this.disp.stop();
                }
                catch (Throwable t) {
                    if (!log.isTraceEnabled()) break block8;
                    log.tracef("Throwable during disp.stop(): %s", t.getMessage());
                }
            }
            this.disp = null;
        }
        if (this.channel != null) {
            block10: {
                block9: {
                    try {
                        this.channel.disconnect();
                    }
                    catch (Throwable t) {
                        if (!log.isTraceEnabled()) break block9;
                        log.tracef("Throwable during channel.disconnect(): %s", t.getMessage());
                    }
                }
                try {
                    this.channel.close();
                }
                catch (Throwable t) {
                    if (!log.isTraceEnabled()) break block10;
                    log.tracef("Throwable during channel.close(): %s", t.getMessage());
                }
            }
            this.channel = null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Serializable sendMessage(Address destAddress, ProtocolMessages.Request request, Serializable ... parameters) throws WorkException {
        Object var4_4 = null;
        if (log.isTraceEnabled()) {
            log.tracef("%s: sending message=%s to %s", this.channel.getAddress(), (Object)request, destAddress);
        }
        if (this.channel == null || !this.channel.isOpen() || !this.channel.isConnected()) {
            if (!log.isTraceEnabled()) return null;
            log.tracef("%s: channel not connected", this.channel != null ? this.channel.getAddress() : "<empty>");
            return null;
        }
        RequestOptions opts = new RequestOptions(ResponseMode.GET_ALL, this.timeout).setFlags(new Message.Flag[]{Message.Flag.OOB});
        try {
            void var4_12;
            switch (request) {
                case JOIN: {
                    Address joiningAddress = (Address)parameters[0];
                    List<Address> dests = destAddress == null ? null : Arrays.asList(destAddress);
                    RspList rspList = this.disp.callRemoteMethods(dests, new MethodCall(1, new Object[]{joiningAddress}), opts);
                    this.throwWorkExceptionIfHasExption((RspList<ProtocolMessages.ResponseValues>)rspList);
                    return var4_12;
                }
                case LEAVE: {
                    Address leavingAddress = (Address)parameters[0];
                    List<Address> dests = destAddress == null ? null : Arrays.asList(destAddress);
                    RspList rspList = this.disp.callRemoteMethods(dests, new MethodCall(2, new Object[]{leavingAddress}), opts);
                    this.throwWorkExceptionIfHasExption((RspList<ProtocolMessages.ResponseValues>)rspList);
                    return var4_12;
                }
                case GET_WORKMANAGERS: {
                    try {
                        Set setOfMaps = (Set)this.disp.callRemoteMethod(destAddress, new MethodCall(4, new Object[0]), opts);
                        if (setOfMaps == null) return var4_12;
                        HashSet<org.jboss.jca.core.spi.workmanager.Address> setOfAddress = new HashSet<org.jboss.jca.core.spi.workmanager.Address>(setOfMaps.size());
                        for (Map map : setOfMaps) {
                            if (map == null) continue;
                            setOfAddress.add(org.jboss.jca.core.spi.workmanager.Address.fromMap((Map)map));
                        }
                        Serializable serializable = setOfAddress;
                        return var4_12;
                    }
                    catch (Exception e) {
                        throw new WorkException((Throwable)e);
                    }
                }
                case WORKMANAGER_ADD: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    Address physicalAddress = (Address)parameters[1];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(5, new Object[]{address, physicalAddress}), opts);
                    return var4_12;
                }
                case WORKMANAGER_REMOVE: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(6, new Object[]{address}), opts);
                    return var4_12;
                }
                case PING: {
                    try {
                        Long l = (Long)this.disp.callRemoteMethod(destAddress, new MethodCall(3, new Object[0]), opts);
                        return var4_12;
                    }
                    catch (WorkException we) {
                        throw we;
                    }
                    catch (Exception e) {
                        throw new WorkException((Throwable)e);
                    }
                }
                case DO_WORK: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    List<Map<String, Object>> cb = ((ClassBundle)parameters[1]).toListOfMaps();
                    DistributableWork work = (DistributableWork)parameters[2];
                    try {
                        this.disp.callRemoteMethod(destAddress, new MethodCall(7, new Object[]{address, cb, this.getBytes(work)}), opts);
                        return var4_12;
                    }
                    catch (WorkException we) {
                        throw we;
                    }
                    catch (Exception e) {
                        throw new WorkException((Throwable)e);
                    }
                }
                case START_WORK: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    List<Map<String, Object>> cb = ((ClassBundle)parameters[1]).toListOfMaps();
                    DistributableWork work = (DistributableWork)parameters[2];
                    Long l = (Long)this.disp.callRemoteMethod(destAddress, new MethodCall(8, new Object[]{address, cb, this.getBytes(work)}), opts);
                    return var4_12;
                }
                case SCHEDULE_WORK: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    List<Map<String, Object>> cb = ((ClassBundle)parameters[1]).toListOfMaps();
                    DistributableWork work = (DistributableWork)parameters[2];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(9, new Object[]{address, cb, this.getBytes(work)}), opts);
                    return var4_12;
                }
                case GET_SHORTRUNNING_FREE: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    Long l = (Long)this.disp.callRemoteMethod(destAddress, new MethodCall(10, new Object[]{address}), opts);
                    return var4_12;
                }
                case GET_LONGRUNNING_FREE: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    Long l = (Long)this.disp.callRemoteMethod(destAddress, new MethodCall(11, new Object[]{address}), opts);
                    return var4_12;
                }
                case UPDATE_SHORTRUNNING_FREE: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    Long freeCount = (Long)parameters[1];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(12, new Object[]{address, freeCount}), opts);
                    return var4_12;
                }
                case UPDATE_LONGRUNNING_FREE: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    Long freeCount = (Long)parameters[1];
                    this.disp.callRemoteMethod(destAddress, new MethodCall(13, new Object[]{address, freeCount}), opts);
                    return var4_12;
                }
                case GET_DISTRIBUTED_STATISTICS: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    Map statisticsMap = (Map)this.disp.callRemoteMethod(destAddress, new MethodCall(14, new Object[]{address}), opts);
                    DistributedWorkManagerStatisticsValues distributedWorkManagerStatisticsValues = DistributedWorkManagerStatisticsValues.fromMap((Map)statisticsMap);
                    return var4_12;
                }
                case CLEAR_DISTRIBUTED_STATISTICS: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(15, new Object[]{address}), opts);
                    return var4_12;
                }
                case DELTA_DOWORK_ACCEPTED: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(16, new Object[]{address}), opts);
                    return var4_12;
                }
                case DELTA_DOWORK_REJECTED: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(17, new Object[]{address}), opts);
                    return var4_12;
                }
                case DELTA_STARTWORK_ACCEPTED: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(18, new Object[]{address}), opts);
                    return var4_12;
                }
                case DELTA_STARTWORK_REJECTED: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(19, new Object[]{address}), opts);
                    return var4_12;
                }
                case DELTA_SCHEDULEWORK_ACCEPTED: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(20, new Object[]{address}), opts);
                    return var4_12;
                }
                case DELTA_SCHEDULEWORK_REJECTED: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(21, new Object[]{address}), opts);
                    return var4_12;
                }
                case DELTA_WORK_SUCCESSFUL: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(22, new Object[]{address}), opts);
                    return var4_12;
                }
                case DELTA_WORK_FAILED: {
                    Map address = ((org.jboss.jca.core.spi.workmanager.Address)parameters[0]).toMap();
                    this.disp.callRemoteMethod(destAddress, new MethodCall(23, new Object[]{address}), opts);
                    return var4_12;
                }
                default: {
                    if (!log.isDebugEnabled()) return var4_12;
                    log.debug("Unknown command received on socket Transport");
                }
            }
            return var4_12;
        }
        catch (WorkException we) {
            throw we;
        }
        catch (Throwable t) {
            WorkException we = new WorkException(t.getMessage());
            we.initCause(t);
            throw we;
        }
    }

    private void throwWorkExceptionIfHasExption(RspList<ProtocolMessages.ResponseValues> rspList) throws WorkException {
        if (rspList != null && rspList.getFirst() != null) {
            for (Rsp rsp : rspList) {
                if (!rsp.hasException()) continue;
                Throwable t = rsp.getException();
                if (t instanceof WorkException) {
                    throw (WorkException)t;
                }
                WorkException we = new WorkException(rsp.getException().getMessage());
                we.initCause(rsp.getException());
                throw we;
            }
        }
    }

    @Override
    public Address getOwnAddress() {
        return this.channel.getAddress();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clustername) {
        this.clusterName = clustername;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long v) {
        this.timeout = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void viewAccepted(View view) {
        if (log.isTraceEnabled()) {
            log.tracef("java.net.preferIPv4Stack=%s", SecurityActions.getSystemProperty("java.net.preferIPv4Stack"));
            log.tracef("viewAccepted called w/ View=%s", view);
            log.tracef("viewAccepted called w/ physicalAdresses=%s", this.nodes.values());
            log.tracef("viewAccepted called w/ members=%s", view.getMembers());
            log.tracef("viewAccepted called w/ channels=%s", this.channel);
        }
        JGroupsTransport jGroupsTransport = this;
        synchronized (jGroupsTransport) {
            ArrayList physicalAddresses = new ArrayList(this.nodes.values().size());
            physicalAddresses.addAll(this.nodes.values());
            for (Address physicalAddress : physicalAddresses) {
                if (physicalAddress == null || view.containsMember(physicalAddress)) continue;
                this.leave(physicalAddress);
            }
            for (Address address : view.getMembers()) {
                if (this.channel == null || this.channel.getAddress().equals(address) || this.nodes.containsValue(address)) continue;
                try {
                    Set logicalAddresses = (Set)((Object)this.sendMessage(address, ProtocolMessages.Request.GET_WORKMANAGERS, new Serializable[0]));
                    if (logicalAddresses == null || logicalAddresses.size() <= 0) continue;
                    for (org.jboss.jca.core.spi.workmanager.Address logicalAddress : logicalAddresses) {
                        this.join(logicalAddress, address);
                        Long shortRunning = this.getShortRunningFree(logicalAddress);
                        Long longRunning = this.getLongRunningFree(logicalAddress);
                        this.localUpdateShortRunningFree(logicalAddress, shortRunning);
                        this.localUpdateLongRunningFree(logicalAddress, longRunning);
                    }
                }
                catch (Throwable t) {
                    log.error("ViewAccepted: " + t.getMessage(), t);
                }
            }
        }
    }

    public void block() {
        log.tracef("block called", new Object[0]);
    }

    public void suspect(Address address) {
        log.tracef("suspect called w/ Address=%s", address);
    }

    public void unblock() {
        log.tracef("unblock called", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytes(DistributableWork dw) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(dw);
            oos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Throwable t) {
            log.error("Error during getBytes: " + t.getMessage(), t);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public String toString() {
        return "JGroupsTransport [channel=" + this.channel + ", clustername=" + this.clusterName + "]";
    }

    static {
        try {
            methods.put((short)1, SecurityActions.getMethod(JGroupsTransport.class, "join", Map.class, Address.class));
            methods.put((short)2, SecurityActions.getMethod(JGroupsTransport.class, "leave", Address.class));
            methods.put((short)3, SecurityActions.getMethod(AbstractRemoteTransport.class, "localPing", new Class[0]));
            methods.put((short)4, SecurityActions.getMethod(JGroupsTransport.class, "getWorkManagers", new Class[0]));
            methods.put((short)5, SecurityActions.getMethod(JGroupsTransport.class, "addWorkManager", Map.class, Address.class));
            methods.put((short)6, SecurityActions.getMethod(JGroupsTransport.class, "workManagerRemove", Map.class));
            methods.put((short)7, SecurityActions.getMethod(JGroupsTransport.class, "executeDoWork", Map.class, List.class, byte[].class));
            methods.put((short)8, SecurityActions.getMethod(JGroupsTransport.class, "executeStartWork", Map.class, List.class, byte[].class));
            methods.put((short)9, SecurityActions.getMethod(JGroupsTransport.class, "executeScheduleWork", Map.class, List.class, byte[].class));
            methods.put((short)10, SecurityActions.getMethod(JGroupsTransport.class, "getShortRunningFree", Map.class));
            methods.put((short)11, SecurityActions.getMethod(JGroupsTransport.class, "getLongRunningFree", Map.class));
            methods.put((short)12, SecurityActions.getMethod(JGroupsTransport.class, "updateShortRunningFree", Map.class, Long.class));
            methods.put((short)13, SecurityActions.getMethod(JGroupsTransport.class, "updateLongRunningFree", Map.class, Long.class));
            methods.put((short)14, SecurityActions.getMethod(JGroupsTransport.class, "getDistributedStatistics", Map.class));
            methods.put((short)15, SecurityActions.getMethod(JGroupsTransport.class, "clearDistributedStatistics", Map.class));
            methods.put((short)16, SecurityActions.getMethod(JGroupsTransport.class, "deltaDoWorkAccepted", Map.class));
            methods.put((short)17, SecurityActions.getMethod(JGroupsTransport.class, "deltaDoWorkRejected", Map.class));
            methods.put((short)18, SecurityActions.getMethod(JGroupsTransport.class, "deltaStartWorkAccepted", Map.class));
            methods.put((short)19, SecurityActions.getMethod(JGroupsTransport.class, "deltaStartWorkRejected", Map.class));
            methods.put((short)20, SecurityActions.getMethod(JGroupsTransport.class, "deltaScheduleWorkAccepted", Map.class));
            methods.put((short)21, SecurityActions.getMethod(JGroupsTransport.class, "deltaScheduleWorkRejected", Map.class));
            methods.put((short)22, SecurityActions.getMethod(JGroupsTransport.class, "deltaWorkSuccessful", Map.class));
            methods.put((short)23, SecurityActions.getMethod(JGroupsTransport.class, "deltaWorkFailed", Map.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

