/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.MessageUtils;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.ActionSource2;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIViewAction;
import jakarta.faces.component.UIViewParameter;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.event.SystemEventListener;
import java.util.EnumSet;

public class ValidateComponentNesting
implements SystemEventListener {
    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        UIComponent root = (UIComponent)event.getSource();
        FacesContext jsf = FacesContext.getCurrentInstance();
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_ITERATION);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)jsf, null, hints);
        root.visitTree(visitContext, (VisitCallback)new ValidateFormNestingCallback());
    }

    private static void addOmittedMessage(FacesContext jsf, String clientId, String key) {
        Object[] params = new Object[]{};
        FacesMessage m = MessageUtils.getExceptionMessage(key, params);
        m.setSeverity(FacesMessage.SEVERITY_WARN);
        jsf.addMessage(clientId, m);
    }

    static class ValidateFormNestingCallback
    implements VisitCallback {
        boolean reportedOmittedFormOnce = false;
        boolean reportedOmittedMetadataOnce = false;

        ValidateFormNestingCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            VisitResult result = VisitResult.ACCEPT;
            if (target instanceof UIForm || target.getFamily().endsWith("Form") || "jakarta_faces_metadata".equals(target.getId())) {
                result = VisitResult.REJECT;
            } else if (target instanceof UIViewParameter || target instanceof UIViewAction) {
                if (this.reportedOmittedMetadataOnce) {
                    result = VisitResult.COMPLETE;
                }
                ValidateComponentNesting.addOmittedMessage(context.getFacesContext(), target.getClientId(context.getFacesContext()), "com.sun.faces.MISSING_METADATA_ERROR");
                this.reportedOmittedMetadataOnce = true;
            } else if (target instanceof EditableValueHolder || target instanceof ActionSource || target instanceof ActionSource2) {
                if (this.reportedOmittedFormOnce) {
                    result = VisitResult.COMPLETE;
                }
                ValidateComponentNesting.addOmittedMessage(context.getFacesContext(), target.getClientId(context.getFacesContext()), "com.sun.faces.MISSING_FORM_ERROR");
                this.reportedOmittedFormOnce = true;
            }
            return result;
        }
    }
}

