/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka;

import io.smallrye.reactive.messaging.kafka.KafkaRecord;
import io.smallrye.reactive.messaging.kafka.OutgoingKafkaRecordMetadata;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class OutgoingKafkaRecord<K, T>
implements KafkaRecord<K, T> {
    private final T value;
    private final Supplier<CompletionStage<Void>> ack;
    private final Function<Throwable, CompletionStage<Void>> nack;
    private final Metadata metadata;
    private final OutgoingKafkaRecordMetadata<K> kafkaMetadata;

    public OutgoingKafkaRecord(String topic, K key, T value, Instant timestamp, int partition, Headers headers, Supplier<CompletionStage<Void>> ack, Function<Throwable, CompletionStage<Void>> nack, Metadata existingMetadata) {
        this.kafkaMetadata = new OutgoingKafkaRecordMetadata<K>(topic, key, partition, timestamp, headers);
        this.metadata = existingMetadata != null ? Metadata.from((Iterable)existingMetadata).with(this.kafkaMetadata) : Metadata.of((Object[])new Object[]{this.kafkaMetadata});
        this.value = value;
        this.ack = ack;
        this.nack = nack;
    }

    public static <K, T> OutgoingKafkaRecord<K, T> from(Message<T> message) {
        OutgoingKafkaRecordMetadata<Object> kafkaMetadata = message.getMetadata(OutgoingKafkaRecordMetadata.class).orElse(new OutgoingKafkaRecordMetadata<Object>(null, null, -1, null, null));
        return new OutgoingKafkaRecord<Object, Object>(kafkaMetadata.getTopic(), kafkaMetadata.getKey(), message.getPayload(), kafkaMetadata.getTimestamp(), kafkaMetadata.getPartition(), kafkaMetadata.getHeaders(), message.getAck(), message.getNack(), message.getMetadata());
    }

    public CompletionStage<Void> ack() {
        if (this.ack == null) {
            return CompletableFuture.completedFuture(null);
        }
        return this.ack.get();
    }

    public T getPayload() {
        return this.value;
    }

    @Override
    public K getKey() {
        return this.kafkaMetadata.getKey();
    }

    @Override
    public String getTopic() {
        return this.kafkaMetadata.getTopic();
    }

    @Override
    public Instant getTimestamp() {
        return this.kafkaMetadata.getTimestamp();
    }

    @Override
    public Headers getHeaders() {
        return this.kafkaMetadata.getHeaders();
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this.ack;
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return this.nack;
    }

    @Override
    public int getPartition() {
        return this.kafkaMetadata.getPartition();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public OutgoingKafkaRecord<K, T> withHeader(final String key, final byte[] content) {
        Headers headers = this.getHeaders();
        RecordHeaders copy = new RecordHeaders((Iterable)headers);
        copy.add(new Header(){

            public String key() {
                return key;
            }

            public byte[] value() {
                return content;
            }
        });
        return new OutgoingKafkaRecord<K, T>(this.getTopic(), this.getKey(), this.getPayload(), this.getTimestamp(), this.getPartition(), (Headers)copy, this.getAck(), this.getNack(), this.getMetadata());
    }

    public OutgoingKafkaRecord<K, T> withHeader(final String key, final String content) {
        Headers headers = this.getHeaders();
        RecordHeaders copy = new RecordHeaders((Iterable)headers);
        copy.add(new Header(){

            public String key() {
                return key;
            }

            public byte[] value() {
                return content.getBytes();
            }
        });
        return new OutgoingKafkaRecord<K, T>(this.getTopic(), this.getKey(), this.getPayload(), this.getTimestamp(), this.getPartition(), (Headers)copy, this.getAck(), this.getNack(), this.getMetadata());
    }

    public OutgoingKafkaRecord<K, T> withHeader(final String key, final String content, final Charset enc) {
        Headers headers = this.getHeaders();
        RecordHeaders copy = new RecordHeaders((Iterable)headers);
        copy.add(new Header(){

            public String key() {
                return key;
            }

            public byte[] value() {
                return content.getBytes(enc);
            }
        });
        return new OutgoingKafkaRecord<K, T>(this.getTopic(), this.getKey(), this.getPayload(), this.getTimestamp(), this.getPartition(), (Headers)copy, this.getAck(), this.getNack(), this.getMetadata());
    }

    public OutgoingKafkaRecord<K, T> with(String topic, K key, T value) {
        return new OutgoingKafkaRecord<K, T>(topic, key, value, this.getTimestamp(), this.getPartition(), this.getHeaders(), this.getAck(), this.getNack(), this.getMetadata());
    }

    public OutgoingKafkaRecord<K, T> with(String topic, T value) {
        return new OutgoingKafkaRecord<K, T>(topic, this.getKey(), value, this.getTimestamp(), this.getPartition(), this.getHeaders(), this.getAck(), this.getNack(), this.getMetadata());
    }

    public OutgoingKafkaRecord<K, T> with(String topic, K key, T value, Instant timestamp, int partition) {
        return new OutgoingKafkaRecord<K, T>(topic, key, value, timestamp, partition, this.getHeaders(), this.getAck(), this.getNack(), this.getMetadata());
    }

    public <P> OutgoingKafkaRecord<K, P> withPayload(P payload) {
        return OutgoingKafkaRecord.from(Message.of(payload, (Metadata)this.getMetadata(), this.getAck(), this.getNack()));
    }

    public OutgoingKafkaRecord<K, T> withMetadata(Iterable<Object> metadata) {
        Metadata newMetadata = this.getMetadata().with(metadata);
        return OutgoingKafkaRecord.from(Message.of(this.getPayload(), (Metadata)newMetadata, this.getAck(), this.getNack()));
    }

    public OutgoingKafkaRecord<K, T> withMetadata(Metadata metadata) {
        Metadata newMetadata = this.getMetadata().with((Object)metadata);
        return OutgoingKafkaRecord.from(Message.of(this.getPayload(), (Metadata)newMetadata, this.getAck(), this.getNack()));
    }

    public OutgoingKafkaRecord<K, T> withAck(Supplier<CompletionStage<Void>> supplier) {
        return OutgoingKafkaRecord.from(Message.of(this.getPayload(), (Metadata)this.getMetadata(), supplier));
    }

    public OutgoingKafkaRecord<K, T> withNack(Function<Throwable, CompletionStage<Void>> nack) {
        return OutgoingKafkaRecord.from(Message.of(this.getPayload(), (Metadata)this.getMetadata(), this.getAck(), nack));
    }
}

