/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors;

import jakarta.ejb.Local;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Remote;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.metadata.MetadataCompleteMarker;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.ViewInterfaces;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;

public class BusinessViewAnnotationProcessor
implements DeploymentUnitProcessor {
    private final boolean appclient;

    public BusinessViewAnnotationProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Class<?> ejbClass;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (MetadataCompleteMarker.isMetadataComplete((DeploymentUnit)deploymentUnit)) {
            return;
        }
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Collection componentDescriptions = eeModuleDescription.getComponentDescriptions();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        ModuleClassLoader moduleClassLoader = module.getClassLoader();
        if (componentDescriptions != null) {
            for (ComponentDescription componentDescription : componentDescriptions) {
                if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
                ejbClass = this.getEjbClass(componentDescription.getComponentClassName(), (ClassLoader)moduleClassLoader);
                try {
                    this.processViewAnnotations(deploymentUnit, ejbClass, (SessionBeanComponentDescription)componentDescription);
                }
                catch (Exception e) {
                    throw EjbLogger.ROOT_LOGGER.failedToProcessBusinessInterfaces(ejbClass, e);
                }
            }
        }
        if (this.appclient) {
            for (ComponentDescription componentDescription : deploymentUnit.getAttachmentList(Attachments.ADDITIONAL_RESOLVABLE_COMPONENTS)) {
                if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
                ejbClass = this.getEjbClass(componentDescription.getComponentClassName(), (ClassLoader)moduleClassLoader);
                try {
                    this.processViewAnnotations(deploymentUnit, ejbClass, (SessionBeanComponentDescription)componentDescription);
                }
                catch (Exception e) {
                    throw EjbLogger.ROOT_LOGGER.failedToProcessBusinessInterfaces(ejbClass, e);
                }
            }
        }
    }

    private void processViewAnnotations(DeploymentUnit deploymentUnit, Class<?> sessionBeanClass, SessionBeanComponentDescription sessionBeanComponentDescription) throws DeploymentUnitProcessingException {
        Collection<Class<?>> localBusinessInterfaces;
        Collection<Class<?>> remoteBusinessInterfaces = this.getRemoteBusinessInterfaces(deploymentUnit, sessionBeanClass);
        if (remoteBusinessInterfaces != null && !remoteBusinessInterfaces.isEmpty()) {
            sessionBeanComponentDescription.addRemoteBusinessInterfaceViews(this.toString(remoteBusinessInterfaces));
        }
        if ((localBusinessInterfaces = this.getLocalBusinessInterfaces(deploymentUnit, sessionBeanClass)) != null && !localBusinessInterfaces.isEmpty()) {
            sessionBeanComponentDescription.addLocalBusinessInterfaceViews(this.toString(localBusinessInterfaces));
        }
        if (BusinessViewAnnotationProcessor.hasNoInterfaceView(sessionBeanClass)) {
            sessionBeanComponentDescription.addNoInterfaceView();
        }
        if (BusinessViewAnnotationProcessor.hasNoViews(sessionBeanComponentDescription)) {
            Set<Class<?>> potentialBusinessInterfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (potentialBusinessInterfaces.isEmpty()) {
                sessionBeanComponentDescription.addNoInterfaceView();
            } else if (potentialBusinessInterfaces.size() == 1) {
                sessionBeanComponentDescription.addLocalBusinessInterfaceViews(potentialBusinessInterfaces.iterator().next().getName());
            } else if (this.isEjbVersionGreaterThanOrEqualTo32(deploymentUnit)) {
                sessionBeanComponentDescription.addLocalBusinessInterfaceViews(this.toString(potentialBusinessInterfaces));
            }
        }
    }

    private Collection<Class<?>> getRemoteBusinessInterfaces(DeploymentUnit deploymentUnit, Class<?> sessionBeanClass) throws DeploymentUnitProcessingException {
        Remote remoteViewAnnotation;
        try {
            remoteViewAnnotation = sessionBeanClass.getAnnotation(Remote.class);
        }
        catch (ArrayStoreException e) {
            throw EjbLogger.ROOT_LOGGER.missingClassInAnnotation(Remote.class.getSimpleName(), sessionBeanClass.getName());
        }
        if (remoteViewAnnotation == null) {
            Collection<Class<?>> interfaces = BusinessViewAnnotationProcessor.getBusinessInterfacesFromInterfaceAnnotations(sessionBeanClass, Remote.class);
            if (!interfaces.isEmpty()) {
                return interfaces;
            }
            return Collections.emptySet();
        }
        Class[] remoteViews = remoteViewAnnotation.value();
        if (remoteViews == null || remoteViews.length == 0) {
            Set<Class<?>> interfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (interfaces.size() != 1 && !this.isEjbVersionGreaterThanOrEqualTo32(deploymentUnit)) {
                throw EjbLogger.ROOT_LOGGER.beanWithRemoteAnnotationImplementsMoreThanOneInterface(sessionBeanClass);
            }
            return interfaces;
        }
        return Arrays.asList(remoteViews);
    }

    private Collection<Class<?>> getLocalBusinessInterfaces(DeploymentUnit deploymentUnit, Class<?> sessionBeanClass) throws DeploymentUnitProcessingException {
        Local localViewAnnotation;
        try {
            localViewAnnotation = sessionBeanClass.getAnnotation(Local.class);
        }
        catch (ArrayStoreException e) {
            throw EjbLogger.ROOT_LOGGER.missingClassInAnnotation(Local.class.getSimpleName(), sessionBeanClass.getName());
        }
        if (localViewAnnotation == null) {
            Collection<Class<?>> interfaces = BusinessViewAnnotationProcessor.getBusinessInterfacesFromInterfaceAnnotations(sessionBeanClass, Local.class);
            if (!interfaces.isEmpty()) {
                return interfaces;
            }
            return Collections.emptySet();
        }
        Class[] localViews = localViewAnnotation.value();
        if (localViews == null || localViews.length == 0) {
            Set<Class<?>> interfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
            if (interfaces.size() != 1 && !this.isEjbVersionGreaterThanOrEqualTo32(deploymentUnit)) {
                throw EjbLogger.ROOT_LOGGER.beanWithLocalAnnotationImplementsMoreThanOneInterface(sessionBeanClass);
            }
            return interfaces;
        }
        return Arrays.asList(localViews);
    }

    private static Collection<Class<?>> getBusinessInterfacesFromInterfaceAnnotations(Class<?> sessionBeanClass, Class<? extends Annotation> annotation) throws DeploymentUnitProcessingException {
        Set<Class<?>> potentialBusinessInterfaces = BusinessViewAnnotationProcessor.getPotentialBusinessInterfaces(sessionBeanClass);
        HashSet businessInterfaces = new HashSet();
        for (Class<?> iface : potentialBusinessInterfaces) {
            try {
                if (iface.getAnnotation(annotation) == null) continue;
                businessInterfaces.add(iface);
            }
            catch (ArrayStoreException e) {
                throw EjbLogger.ROOT_LOGGER.missingClassInAnnotation(annotation.getSimpleName(), iface.getName());
            }
        }
        return businessInterfaces;
    }

    private static Set<Class<?>> getPotentialBusinessInterfaces(Class<?> sessionBeanClass) {
        return ViewInterfaces.getPotentialViewInterfaces(sessionBeanClass);
    }

    private static boolean hasNoInterfaceView(Class<?> sessionBeanClass) {
        return sessionBeanClass.getAnnotation(LocalBean.class) != null;
    }

    private static boolean hasNoViews(SessionBeanComponentDescription sessionBeanComponentDescription) {
        return sessionBeanComponentDescription.getViews() == null || sessionBeanComponentDescription.getViews().isEmpty();
    }

    private Class<?> getEjbClass(String className, ClassLoader cl) throws DeploymentUnitProcessingException {
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
    }

    private Collection<String> toString(Collection<Class<?>> classes) {
        ArrayList<String> classNames = new ArrayList<String>(classes.size());
        for (Class<?> klass : classes) {
            classNames.add(klass.getName());
        }
        return classNames;
    }

    private boolean isEjbVersionGreaterThanOrEqualTo32(DeploymentUnit deploymentUnit) {
        if (deploymentUnit == null) {
            return false;
        }
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData == null) {
            return true;
        }
        return ejbJarMetaData.isVersionGreaterThanOrEqual(EjbJarVersion.EJB_3_2);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

